/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.infrastructure.worldgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AllPlacedFeatures {
    public static final ResourceKey<PlacedFeature> ZINC_ORE = AllPlacedFeatures.register("zinc_ore");
    public static final ResourceKey<PlacedFeature> STRIATED_ORES_OVERWORLD = AllPlacedFeatures.register("striated_ores_overworld");
    public static final ResourceKey<PlacedFeature> STRIATED_ORES_NETHER = AllPlacedFeatures.register("striated_ores_nether");

    public static ResourceKey<PlacedFeature> register(String id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (Identifier)Identifier.fromNamespaceAndPath((String)"create", (String)id));
    }

    public static void register(RegistryAccess registryManager) {
        Registry placed = registryManager.lookupOrThrow(Registries.PLACED_FEATURE);
        Holder zincOverworld = (Holder)placed.get(ZINC_ORE).orElseThrow();
        Holder striatedOverworld = (Holder)placed.get(STRIATED_ORES_OVERWORLD).orElseThrow();
        Holder striatedNether = (Holder)placed.get(STRIATED_ORES_NETHER).orElseThrow();
        int index = GenerationStep.Decoration.UNDERGROUND_ORES.ordinal();
        AllPlacedFeatures.addFeature(registryManager, (ResourceKey<LevelStem>)LevelStem.OVERWORLD, index, List.of(zincOverworld, striatedOverworld));
        AllPlacedFeatures.addFeature(registryManager, (ResourceKey<LevelStem>)LevelStem.NETHER, index, List.of(striatedNether));
    }

    private static void addFeature(RegistryAccess registryManager, ResourceKey<LevelStem> options, int index, List<Holder<PlacedFeature>> entries) {
        ((LevelStem)registryManager.lookupOrThrow(Registries.LEVEL_STEM).getValue(options)).generator().getBiomeSource().possibleBiomes().stream().map(Holder::value).map(Biome::getGenerationSettings).forEach(settings -> {
            List features;
            int size;
            if (!(settings.features instanceof ArrayList)) {
                settings.features = new ArrayList(settings.features);
            }
            if ((size = (features = settings.features).size()) <= index) {
                for (int i = size; i < index; ++i) {
                    features.add(HolderSet.direct(Collections.emptyList()));
                }
                features.add(HolderSet.direct((List)entries));
            } else {
                HolderSet values = (HolderSet)features.get(index);
                if (values != null) {
                    ArrayList list = new ArrayList(values.stream().toList());
                    list.addAll(entries);
                    values = HolderSet.direct(list);
                } else {
                    values = HolderSet.direct((List)entries);
                }
                features.set(index, values);
            }
        });
    }

    public static void register() {
    }
}

