/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.mixin;

import com.zurrtum.create.foundation.pack.DynamicPack;
import com.zurrtum.create.foundation.pack.RuntimeDataGenerator;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BuiltInPackSource.class})
public class BuiltInPackSourceMixin {
    @Inject(method={"loadPacks(Ljava/util/function/Consumer;)V"}, at={@At(value="TAIL")})
    private void addDataPack(Consumer<Pack> consumer, CallbackInfo ci) {
        if (this instanceof ServerPacksSource) {
            FabricLoader loader = FabricLoader.getInstance();
            if (!loader.isModLoaded("fabric-api")) {
                String directory = PackType.SERVER_DATA.getDirectory();
                ModContainer mod = (ModContainer)loader.getModContainer("create").orElseThrow();
                List paths = mod.getRootPaths();
                BuiltInPackSourceMixin.addDataPack(consumer, BuiltInPackSourceMixin.createInfo("fabric-convention-tags-v2", "Fabric Convention Tags (v2)", "2.15.2+d9a8963096"), paths, Component.nullToEmpty((String)"fabric-convention-tags-v2-2.15.2+d9a8963096"), directory + "/fabric", "c");
                ModMetadata metadata = mod.getMetadata();
                BuiltInPackSourceMixin.addDataPack(consumer, BuiltInPackSourceMixin.createInfo("create", metadata.getName(), metadata.getVersion().getFriendlyString()), paths, (Component)Component.translatable((String)"advancement.create.root"), directory, "create", "minecraft", "c");
            }
            DynamicPack dynamicPack = new DynamicPack("create:dynamic_data", (Component)Component.translatable((String)"advancement.create.root"), PackType.SERVER_DATA);
            RuntimeDataGenerator.insertIntoPack(dynamicPack);
            if (!dynamicPack.isEmpty()) {
                BuiltInPackSourceMixin.addDataPack(consumer, false, dynamicPack);
            }
        }
    }

    @Unique
    private static PackLocationInfo createInfo(String id, String name, String version) {
        return new PackLocationInfo(id, Component.nullToEmpty((String)name), PackSource.BUILT_IN, Optional.of(new KnownPack(id, "data", version)));
    }

    @Unique
    private static void addDataPack(Consumer<Pack> consumer, PackLocationInfo info, List<Path> paths, Component title, String directory, String ... namespace) {
        BuiltInMetadata metadataMap = BuiltInMetadata.of((MetadataSectionType)PackMetadataSection.SERVER_TYPE, (Object)new PackMetadataSection(title, SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA).minorRange()));
        VanillaPackResourcesBuilder builder = new VanillaPackResourcesBuilder().setMetadata(metadataMap).exposeNamespace(namespace);
        for (Path path : paths) {
            builder.pushAssetPath(PackType.SERVER_DATA, path.resolve(directory));
        }
        BuiltInPackSourceMixin.addDataPack(consumer, true, (PackResources)builder.build(info));
    }

    @Unique
    private static void addDataPack(Consumer<Pack> consumer, boolean required, final PackResources pack) {
        Pack.ResourcesSupplier packFactory = new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo info) {
                return pack;
            }

            public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                return pack;
            }
        };
        PackSelectionConfig position = new PackSelectionConfig(required, Pack.Position.BOTTOM, false);
        consumer.accept(Pack.readMetaAndCreate((PackLocationInfo)pack.location(), (Pack.ResourcesSupplier)packFactory, (PackType)PackType.SERVER_DATA, (PackSelectionConfig)position));
    }
}

