/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.zurrtum.create.foundation.recipe.ComponentsIngredient;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Ingredient.class})
public class IngredientMixin {
    @Mutable
    @Shadow
    @Final
    public static Codec<Ingredient> CODEC;

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/codec/StreamCodec;map(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/StreamCodec;", ordinal=0)})
    private static StreamCodec<RegistryFriendlyByteBuf, Ingredient> getPacketCodec(final StreamCodec<RegistryFriendlyByteBuf, Ingredient> packetCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Ingredient>(){

            public Ingredient decode(RegistryFriendlyByteBuf buf) {
                int index = buf.readerIndex();
                if (buf.readVarInt() != -1) {
                    buf.readerIndex(index);
                    return (Ingredient)packetCodec.decode((Object)buf);
                }
                return (Ingredient)ComponentsIngredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            }

            public void encode(RegistryFriendlyByteBuf buf, Ingredient value) {
                if (value instanceof ComponentsIngredient) {
                    ComponentsIngredient componentsIngredient = (ComponentsIngredient)value;
                    buf.writeVarInt(-1);
                    ComponentsIngredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)componentsIngredient);
                } else {
                    packetCodec.encode((Object)buf, (Object)value);
                }
            }
        };
    }

    @ModifyExpressionValue(method={"<clinit>"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/codec/StreamCodec;map(Ljava/util/function/Function;Ljava/util/function/Function;)Lnet/minecraft/network/codec/StreamCodec;", ordinal=1)})
    private static StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> getIngredientPacketCodec(final StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>> packetCodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, Optional<Ingredient>>(){

            public Optional<Ingredient> decode(RegistryFriendlyByteBuf buf) {
                int index = buf.readerIndex();
                if (buf.readVarInt() != -1) {
                    buf.readerIndex(index);
                    return (Optional)packetCodec.decode((Object)buf);
                }
                return Optional.of((Ingredient)ComponentsIngredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            }

            public void encode(RegistryFriendlyByteBuf buf, Optional<Ingredient> value) {
                Ingredient ingredient;
                if (value.isPresent() && (ingredient = value.get()) instanceof ComponentsIngredient) {
                    ComponentsIngredient componentsIngredient = (ComponentsIngredient)ingredient;
                    buf.writeVarInt(-1);
                    ComponentsIngredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)componentsIngredient);
                } else {
                    packetCodec.encode((Object)buf, value);
                }
            }
        };
    }

    @Inject(method={"<clinit>"}, at={@At(value="TAIL")})
    private static void injectCodec(CallbackInfo ci) {
        final Codec<Ingredient> codec = CODEC;
        CODEC = new Codec<Ingredient>(){

            public <T> DataResult<Pair<Ingredient, T>> decode(DynamicOps<T> ops, T input) {
                DataResult map = ops.getMap(input);
                if (map.isError()) {
                    return codec.decode(ops, input);
                }
                Object type = ((MapLike)map.getOrThrow()).get("fabric:type");
                if (type == null) {
                    return codec.decode(ops, input);
                }
                if (((String)ops.getStringValue(type).getOrThrow()).equals(ComponentsIngredient.STRING_ID)) {
                    return ComponentsIngredient.CODEC.decode(ops, input);
                }
                return codec.decode(ops, input);
            }

            public <T> DataResult<T> encode(Ingredient input, DynamicOps<T> ops, T prefix) {
                if (input instanceof ComponentsIngredient) {
                    ComponentsIngredient componentsIngredient = (ComponentsIngredient)input;
                    return ComponentsIngredient.CODEC.encode((Object)componentsIngredient, ops, prefix);
                }
                return codec.encode((Object)input, ops, prefix);
            }
        };
    }
}

