/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.api.behaviour.display;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDisplayTargets;
import com.zurrtum.create.api.behaviour.display.DisplayHolder;
import com.zurrtum.create.api.registry.CreateRegistries;
import com.zurrtum.create.api.registry.SimpleRegistry;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayTarget {
    public static final SimpleRegistry<Block, DisplayTarget> BY_BLOCK = SimpleRegistry.create();
    public static final SimpleRegistry<BlockEntityType<?>, DisplayTarget> BY_BLOCK_ENTITY = SimpleRegistry.create();

    public abstract void acceptText(int var1, List<MutableComponent> var2, DisplayLinkContext var3);

    public abstract DisplayTargetStats provideStats(DisplayLinkContext var1);

    public Component getLineOptionText(int line) {
        return Component.translatable((String)"create.display_target.line", (Object[])new Object[]{line + 1});
    }

    public static void reserve(int line, DisplayHolder target, DisplayLinkContext context) {
        if (line == 0) {
            return;
        }
        target.updateLine(line, context.blockEntity().getBlockPos());
    }

    public boolean isReserved(int line, DisplayHolder target, DisplayLinkContext context) {
        BlockPos reserved = target.getLine(line);
        if (reserved == null) {
            return false;
        }
        if (!reserved.equals((Object)context.blockEntity().getBlockPos()) && context.level().getBlockState(reserved).is((Block)AllBlocks.DISPLAY_LINK)) {
            return true;
        }
        target.removeLine(line);
        return false;
    }

    public boolean requiresComponentSanitization() {
        return false;
    }

    @Nullable
    public static DisplayTarget get(@Nullable Identifier id) {
        if (id == null) {
            return null;
        }
        return (DisplayTarget)CreateRegistries.DISPLAY_TARGET.getValue(id);
    }

    @Nullable
    public static DisplayTarget get(LevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        DisplayTarget byBlock = BY_BLOCK.get((StateHolder<Block, ?>)state);
        if (byBlock != null) {
            return byBlock;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be == null) {
            return null;
        }
        DisplayTarget byBe = BY_BLOCK_ENTITY.get(be.getType());
        if (byBe != null) {
            return byBe;
        }
        return be instanceof SignBlockEntity ? AllDisplayTargets.SIGN : null;
    }

    public AABB getMultiblockBounds(LevelAccessor level, BlockPos pos) {
        VoxelShape shape = level.getBlockState(pos).getShape((BlockGetter)level, pos);
        if (shape.isEmpty()) {
            return new AABB(pos);
        }
        return shape.bounds().move(pos);
    }
}

