/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.nbt;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class NBTHelper {
    public static void putMarker(CompoundTag nbt, String marker) {
        nbt.putBoolean(marker, true);
    }

    public static BlockPos readBlockPos(CompoundTag nbt, String key) {
        BlockPos pos = nbt.read(key, BlockPos.CODEC).orElse(null);
        if (pos != null) {
            return pos;
        }
        CompoundTag oldTag = nbt.getCompoundOrEmpty(key);
        return new BlockPos(oldTag.getIntOr("X", 0), oldTag.getIntOr("Y", 0), oldTag.getIntOr("Z", 0));
    }

    public static <T extends Enum<?>> T readEnum(CompoundTag nbt, String key, Class<T> enumClass) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        if (enumConstants == null) {
            throw new IllegalArgumentException("Non-Enum class passed to readEnum: " + enumClass.getName());
        }
        if (nbt.contains(key)) {
            String name = nbt.getStringOr(key, "");
            for (Enum t : enumConstants) {
                if (!t.name().equals(name)) continue;
                return (T)t;
            }
        }
        return (T)enumConstants[0];
    }

    public static <T extends Enum<?>> void writeEnum(CompoundTag nbt, String key, T enumConstant) {
        nbt.putString(key, enumConstant.name());
    }

    public static <T> ListTag writeCompoundList(Iterable<T> list, Function<T, CompoundTag> serializer) {
        ListTag listNBT = new ListTag();
        list.forEach(t -> {
            CompoundTag apply = (CompoundTag)serializer.apply(t);
            if (apply == null) {
                return;
            }
            listNBT.add((Object)apply);
        });
        return listNBT;
    }

    public static <T> List<T> readCompoundList(ListTag listNBT, Function<CompoundTag, T> deserializer) {
        ArrayList list = new ArrayList(listNBT.size());
        listNBT.forEach(inbt -> list.add(deserializer.apply((CompoundTag)inbt)));
        return list;
    }

    public static void iterateCompoundList(ListTag listNBT, Consumer<CompoundTag> consumer) {
        listNBT.forEach(inbt -> consumer.accept((CompoundTag)inbt));
    }

    public static ListTag writeAABB(AABB bb) {
        ListTag bbtag = new ListTag();
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.minX)));
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.minY)));
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.minZ)));
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.maxX)));
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.maxY)));
        bbtag.add((Object)FloatTag.valueOf((float)((float)bb.maxZ)));
        return bbtag;
    }

    @Nullable
    public static AABB readAABB(ListTag bbTag) {
        if (bbTag.isEmpty()) {
            return null;
        }
        return new AABB((double)bbTag.getFloatOr(0, 0.0f), (double)bbTag.getFloatOr(1, 0.0f), (double)bbTag.getFloatOr(2, 0.0f), (double)bbTag.getFloatOr(3, 0.0f), (double)bbTag.getFloatOr(4, 0.0f), (double)bbTag.getFloatOr(5, 0.0f));
    }

    public static ListTag writeVec3i(Vec3i vec) {
        ListTag tag = new ListTag();
        tag.add((Object)IntTag.valueOf((int)vec.getX()));
        tag.add((Object)IntTag.valueOf((int)vec.getY()));
        tag.add((Object)IntTag.valueOf((int)vec.getZ()));
        return tag;
    }

    public static Vec3i readVec3i(ListTag tag) {
        return new Vec3i(tag.getIntOr(0, 0), tag.getIntOr(1, 0), tag.getIntOr(2, 0));
    }

    public static Tag getINBT(CompoundTag nbt, String id) {
        Tag inbt = nbt.get(id);
        if (inbt != null) {
            return inbt;
        }
        return new CompoundTag();
    }

    public static CompoundTag intToCompound(int i) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("V", i);
        return compoundTag;
    }

    public static int intFromCompound(CompoundTag compoundTag) {
        return compoundTag.getIntOr("V", 0);
    }

    public static void writeIdentifier(CompoundTag nbt, String key, Identifier location) {
        nbt.putString(key, location.toString());
    }

    public static Identifier readIdentifier(CompoundTag nbt, String key) {
        return Identifier.parse((String)nbt.getStringOr(key, ""));
    }
}

