/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.catnip.nbt;

import com.zurrtum.create.catnip.codecs.CatnipCodecUtils;
import com.zurrtum.create.catnip.components.ComponentProcessors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class NBTProcessors {
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> processors = new HashMap();
    private static final Map<BlockEntityType<?>, UnaryOperator<CompoundTag>> survivalProcessors = new HashMap();
    private static final UnaryOperator<CompoundTag> signProcessor = data -> {
        for (String key : List.of("front_text", "back_text")) {
            SignText text = data.getCompound(key).flatMap(k -> CatnipCodecUtils.decode(SignText.DIRECT_CODEC, (Tag)k)).orElse(null);
            if (text == null) continue;
            for (Component component : text.getMessages(false)) {
                if (!NBTProcessors.textComponentHasClickEvent(component)) continue;
                return null;
            }
        }
        if (data.contains("front_item") || data.contains("back_item")) {
            return null;
        }
        return data;
    };

    public static synchronized void addProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        processors.put(type, processor);
    }

    public static synchronized void addSurvivalProcessor(BlockEntityType<?> type, UnaryOperator<CompoundTag> processor) {
        survivalProcessors.put(type, processor);
    }

    public static UnaryOperator<CompoundTag> itemProcessor(String tagKey) {
        return data -> {
            CompoundTag compound = data.getCompoundOrEmpty(tagKey);
            if (!compound.contains("components")) {
                return data;
            }
            CompoundTag itemComponents = compound.getCompoundOrEmpty("components");
            HashSet keys = new HashSet(itemComponents.keySet());
            for (String key : keys) {
                DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(Identifier.parse((String)key));
                if (type == null || !ComponentProcessors.isUnsafeItemComponent(type)) continue;
                itemComponents.remove(key);
            }
            if (itemComponents.isEmpty()) {
                compound.remove("components");
            }
            return data;
        };
    }

    public static boolean textComponentHasClickEvent(Component component) {
        for (Component sibling : component.getSiblings()) {
            if (!NBTProcessors.textComponentHasClickEvent(sibling)) continue;
            return true;
        }
        return component.getStyle().getClickEvent() != null;
    }

    private NBTProcessors() {
    }

    @Nullable
    public static CompoundTag process(BlockState state, BlockEntity blockEntity, @Nullable CompoundTag compound, boolean survival) {
        if (compound == null) {
            return null;
        }
        BlockEntityType type = blockEntity.getType();
        if (survival && survivalProcessors.containsKey(type)) {
            compound = (CompoundTag)survivalProcessors.get(type).apply(compound);
        }
        if (compound != null && processors.containsKey(type)) {
            return (CompoundTag)processors.get(type).apply(compound);
        }
        if (blockEntity instanceof SpawnerBlockEntity) {
            return compound;
        }
        if (state.is(BlockTags.ALL_SIGNS)) {
            return (CompoundTag)signProcessor.apply(compound);
        }
        return compound;
    }
}

