/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.foundation.block.connected.CTSpriteShiftEntry;
import com.zurrtum.create.content.fluids.pipes.EncasedPipeBlock;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.zurrtum.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AllCasings {
    private static final Map<Block, Entry> ALL = new IdentityHashMap<Block, Entry>();

    public static Entry get(BlockState state) {
        return ALL.get(state.getBlock());
    }

    public static Entry make(Block block, CTSpriteShiftEntry casing) {
        return AllCasings.make(block, casing, (s, f) -> true);
    }

    public static Entry make(Block block, CTSpriteShiftEntry casing, BiPredicate<BlockState, Direction> predicate) {
        Entry entry = new Entry(casing, predicate);
        ALL.put(block, entry);
        return entry;
    }

    public static void register() {
        AllCasings.make(AllBlocks.ANDESITE_CASING, AllSpriteShifts.ANDESITE_CASING);
        AllCasings.make(AllBlocks.BRASS_CASING, AllSpriteShifts.BRASS_CASING);
        AllCasings.make(AllBlocks.COPPER_CASING, AllSpriteShifts.COPPER_CASING);
        AllCasings.make(AllBlocks.RAILWAY_CASING, AllSpriteShifts.RAILWAY_CASING_SIDE);
        AllCasings.make(AllBlocks.SHADOW_STEEL_CASING, AllSpriteShifts.SHADOW_STEEL_CASING);
        AllCasings.make(AllBlocks.REFINED_RADIANCE_CASING, AllSpriteShifts.REFINED_RADIANCE_CASING);
        AllCasings.make(AllBlocks.GEARBOX, AllSpriteShifts.ANDESITE_CASING, (s, f) -> f.getAxis() == s.getValue((Property)GearboxBlock.AXIS));
        AllCasings.make(AllBlocks.ANDESITE_ENCASED_SHAFT, AllSpriteShifts.ANDESITE_CASING, (s, f) -> f.getAxis() != s.getValue((Property)EncasedShaftBlock.AXIS));
        AllCasings.make(AllBlocks.BRASS_ENCASED_SHAFT, AllSpriteShifts.BRASS_CASING, (s, f) -> f.getAxis() != s.getValue((Property)EncasedShaftBlock.AXIS));
        AllCasings.make(AllBlocks.ANDESITE_ENCASED_COGWHEEL, AllSpriteShifts.ANDESITE_CASING, (s, f) -> f.getAxis() == s.getValue((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false);
        AllCasings.make(AllBlocks.BRASS_ENCASED_COGWHEEL, AllSpriteShifts.BRASS_CASING, (s, f) -> f.getAxis() == s.getValue((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false);
        AllCasings.make(AllBlocks.ANDESITE_ENCASED_LARGE_COGWHEEL, AllSpriteShifts.ANDESITE_CASING, (s, f) -> f.getAxis() == s.getValue((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false);
        AllCasings.make(AllBlocks.BRASS_ENCASED_LARGE_COGWHEEL, AllSpriteShifts.BRASS_CASING, (s, f) -> f.getAxis() == s.getValue((Property)EncasedCogwheelBlock.AXIS) && (Boolean)s.getValue((Property)(f.getAxisDirection() == Direction.AxisDirection.POSITIVE ? EncasedCogwheelBlock.TOP_SHAFT : EncasedCogwheelBlock.BOTTOM_SHAFT)) == false);
        AllCasings.make(AllBlocks.ENCASED_FLUID_PIPE, AllSpriteShifts.COPPER_CASING, (s, f) -> (Boolean)s.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false);
    }

    public static class Entry {
        private final CTSpriteShiftEntry casing;
        private final BiPredicate<BlockState, Direction> predicate;

        private Entry(CTSpriteShiftEntry casing, BiPredicate<BlockState, Direction> predicate) {
            this.casing = casing;
            this.predicate = predicate;
        }

        public CTSpriteShiftEntry getCasing() {
            return this.casing;
        }

        public boolean isSideValid(BlockState state, Direction face) {
            return this.predicate.test(state, face);
        }
    }
}

