/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.foundation.block.render.MultiPosDestructionHandler;
import com.zurrtum.create.client.infrastructure.model.CopycatModel;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelStructuralBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AllExtensions {
    public static final Map<Block, BiFunction<BlockAndTintGetter, BlockPos, ChunkSectionLayer>> LAYER = new IdentityHashMap<Block, BiFunction<BlockAndTintGetter, BlockPos, ChunkSectionLayer>>();
    public static final Map<Block, MultiPosDestructionHandler> MULTI_POS = new IdentityHashMap<Block, MultiPosDestructionHandler>();
    public static final Set<Block> BIG_OUTLINE = new HashSet<Block>();
    public static final Map<Item, HumanoidModel.ArmPose> ARM_POSE = new IdentityHashMap<Item, HumanoidModel.ArmPose>();

    public static void register() {
        MULTI_POS.put(AllBlocks.BELT, (level, pos, state, progress) -> {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BeltBlockEntity) {
                BeltBlockEntity belt = (BeltBlockEntity)blockEntity;
                return new HashSet<BlockPos>(BeltBlock.getBeltChain((LevelReader)level, belt.getController()));
            }
            return null;
        });
        MULTI_POS.put((Block)AllBlocks.WATER_WHEEL_STRUCTURAL, (level, pos, state, progress) -> {
            if (!AllBlocks.WATER_WHEEL_STRUCTURAL.stillValid((BlockGetter)level, pos, state, false)) {
                return null;
            }
            HashSet<BlockPos> set = new HashSet<BlockPos>();
            set.add(WaterWheelStructuralBlock.getMaster((BlockGetter)level, pos, state));
            return set;
        });
        MULTI_POS.put(AllBlocks.TRACK, (level, pos, state, progress) -> {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TrackBlockEntity) {
                TrackBlockEntity track = (TrackBlockEntity)blockEntity;
                return new HashSet<BlockPos>(track.getConnections().keySet());
            }
            return null;
        });
        BIG_OUTLINE.add(AllBlocks.CHAIN_CONVEYOR);
        BIG_OUTLINE.add((Block)AllBlocks.ANDESITE_DOOR);
        BIG_OUTLINE.add((Block)AllBlocks.BRASS_DOOR);
        BIG_OUTLINE.add((Block)AllBlocks.COPPER_DOOR);
        BIG_OUTLINE.add((Block)AllBlocks.TRAIN_DOOR);
        BIG_OUTLINE.add((Block)AllBlocks.FRAMED_GLASS_DOOR);
        BIG_OUTLINE.add(AllBlocks.TRACK);
        BIG_OUTLINE.add(AllBlocks.WHITE_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.ORANGE_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.MAGENTA_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.LIGHT_BLUE_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.YELLOW_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.LIME_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.PINK_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.GRAY_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.LIGHT_GRAY_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.CYAN_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.PURPLE_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.BLUE_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.BROWN_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.GREEN_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.RED_TABLE_CLOTH);
        BIG_OUTLINE.add(AllBlocks.BLACK_TABLE_CLOTH);
        ARM_POSE.put((Item)AllItems.POTATO_CANNON, HumanoidModel.ArmPose.CROSSBOW_HOLD);
        ARM_POSE.put(AllItems.WORLDSHAPER, HumanoidModel.ArmPose.CROSSBOW_HOLD);
        LAYER.put(AllBlocks.COPYCAT_STEP, CopycatModel::getLayer);
        LAYER.put(AllBlocks.COPYCAT_PANEL, CopycatModel::getLayer);
    }
}

