/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client;

import com.zurrtum.create.api.equipment.potatoCannon.PotatoProjectileRenderMode;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.equipment.potatoCannon.PotatoProjectileTransform;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.potatoCannon.AllPotatoProjectileRenderModes;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class AllPotatoProjectileTransforms {
    public static final Map<Class<? extends PotatoProjectileRenderMode>, PotatoProjectileTransform<?>> ALL = new IdentityHashMap();

    public static <T extends PotatoProjectileRenderMode> PotatoProjectileTransform<T> get(T renderMode) {
        return ALL.get(renderMode.getClass());
    }

    private static <T extends PotatoProjectileRenderMode> void register(Class<T> renderMode, PotatoProjectileTransform<T> transform) {
        ALL.put(renderMode, transform);
    }

    public static void register() {
        AllPotatoProjectileTransforms.register(AllPotatoProjectileRenderModes.Billboard.class, (mode, ms, state) -> {
            Vec3 p1 = state.camera.getEyePosition(state.pt);
            Vec3 diff = state.box.getCenter().subtract(p1);
            ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(Mth.atan2((double)diff.x, (double)diff.z)) + 180.0f)).rotateXDegrees(AngleHelper.deg(Mth.atan2((double)diff.y, (double)Mth.sqrt((float)((float)(diff.x * diff.x + diff.z * diff.z))))));
        });
        AllPotatoProjectileTransforms.register(AllPotatoProjectileRenderModes.Tumble.class, (mode, ms, state) -> {
            AllPotatoProjectileTransforms.get(AllPotatoProjectileRenderModes.Billboard.INSTANCE).transform(AllPotatoProjectileRenderModes.Billboard.INSTANCE, ms, state);
            ((PoseTransformStack)TransformStack.of(ms).rotateZDegrees(state.ageInTicks * 2.0f * (float)(state.hash % 16))).rotateXDegrees(state.ageInTicks * (float)(state.hash % 32));
        });
        AllPotatoProjectileTransforms.register(AllPotatoProjectileRenderModes.TowardMotion.class, (mode, ms, state) -> {
            Vec3 diff = state.velocity;
            ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(Mth.atan2((double)diff.x, (double)diff.z)))).rotateXDegrees(270.0f + AngleHelper.deg(Mth.atan2((double)diff.y, (double)(-Mth.sqrt((float)((float)(diff.x * diff.x + diff.z * diff.z)))))));
            ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(state.ageInTicks * 20.0f * mode.spin() + (float)(state.hash % 360))).rotateZDegrees(-mode.spriteAngleOffset());
        });
        AllPotatoProjectileTransforms.register(AllPotatoProjectileRenderModes.StuckToEntity.class, (mode, ms, state) -> {
            Vec3 offset = mode.offset();
            TransformStack.of(ms).rotateYDegrees(AngleHelper.deg(Mth.atan2((double)offset.x, (double)offset.z)));
        });
    }
}

