/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.api.goggles;

import com.zurrtum.create.client.api.goggles.IHaveCustomOverlayIcon;
import com.zurrtum.create.client.catnip.lang.LangBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public non-sealed interface IHaveGoggleInformation
extends IHaveCustomOverlayIcon {
    default public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return false;
    }

    default public boolean containedFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking, FluidInventory handler) {
        if (handler == null) {
            return false;
        }
        int size = handler.size();
        if (size == 0) {
            return false;
        }
        LangBuilder mb = CreateLang.translate("generic.unit.millibuckets", new Object[0]);
        CreateLang.translate("gui.goggles.fluid_container", new Object[0]).forGoggles(tooltip);
        boolean isEmpty = true;
        for (int i = 0; i < size; ++i) {
            FluidStack fluidStack = handler.getStack(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.fluidName(fluidStack).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            CreateLang.builder().add(CreateLang.number((double)fluidStack.getAmount() / 81.0).add(mb).style(ChatFormatting.GOLD)).text(ChatFormatting.GRAY, " / ").add(CreateLang.number((double)handler.getMaxAmount(fluidStack) / 81.0).add(mb).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (size > 1) {
            if (isEmpty) {
                tooltip.removeLast();
            }
            return true;
        }
        if (!isEmpty) {
            return true;
        }
        CreateLang.translate("gui.goggles.fluid_container.capacity", new Object[0]).add(CreateLang.number((double)handler.getMaxAmountPerStack() / 81.0).add(mb).style(ChatFormatting.GOLD)).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        return true;
    }
}

