/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.BoxWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public abstract class NavigatableSimiScreen
extends AbstractSimiScreen {
    public static final Couple<Color> COLOR_NAV_ARROW = Couple.create(new Color(-2136303207, true), new Color(816486809)).map(Color::setImmutable);
    protected static boolean currentlyRenderingPreviousScreen = false;
    protected int depthPointX;
    protected int depthPointY;
    public final LerpedFloat transition = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.1f, LerpedFloat.Chaser.LINEAR);
    protected final LerpedFloat arrowAnimation = LerpedFloat.linear().startWithValue(0.0).chase(0.0, 0.075f, LerpedFloat.Chaser.LINEAR);
    @Nullable
    protected BoxWidget backTrack;

    public NavigatableSimiScreen() {
        Window window = Minecraft.getInstance().getWindow();
        this.depthPointX = window.getGuiScaledWidth() / 2;
        this.depthPointY = window.getGuiScaledHeight() / 2;
    }

    public void onClose() {
        ScreenOpener.clearStack();
        super.onClose();
    }

    public void removed() {
        if (this.backTrack != null) {
            this.backTrack.getRenderElement().clear();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.transition.tickChaser();
        this.arrowAnimation.tickChaser();
    }

    @Override
    protected void init() {
        super.init();
        this.backTrack = null;
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return;
        }
        this.backTrack = (BoxWidget)((AbstractSimiWidget)((ElementWidget)((ElementWidget)((ElementWidget)((BoxWidget)new BoxWidget(31, this.height - 31 - 20).withBounds(20, 20)).withCustomBackground(BoxElement.COLOR_BACKGROUND_FLAT)).enableFade(0, 5)).withPadding(2.0f, 2.0f)).fade(1.0f)).withCallback(() -> ScreenOpener.openPreviousScreen(this, null));
        this.addRenderableWidget(this.backTrack);
        Screen previousScreen = screenHistory.getFirst();
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen screen = (NavigatableSimiScreen)previousScreen;
            screen.initBackTrackIcon(this.backTrack);
        } else {
            this.backTrack.showing(PonderGuiTextures.ICON_DISABLE);
        }
    }

    protected abstract void initBackTrackIcon(BoxWidget var1);

    protected Component backTrackingComponent() {
        if (ScreenOpener.getBackStepScreen() instanceof NavigatableSimiScreen) {
            return Lang.builder("catnip").translate("gui.step_back", new Object[0]).component();
        }
        return Lang.builder("catnip").translate("gui.exit", new Object[0]).component();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.backTrack == null) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.pose();
        int x = Mth.lerpInt((float)this.arrowAnimation.getValue(partialTicks), (int)-9, (int)21);
        int maxX = this.backTrack.getX() + this.backTrack.getWidth();
        Couple<Color> colors = COLOR_NAV_ARROW;
        poseStack.pushMatrix();
        poseStack.translate(0.0f, 0.0f);
        if (x + 30 < this.backTrack.getX()) {
            UIRenderHelper.breadcrumbArrow(graphics, x + 30, this.height - 51, maxX - (x + 30), 20, 5, colors);
        }
        UIRenderHelper.breadcrumbArrow(graphics, x, this.height - 51, 30, 20, 5, colors);
        UIRenderHelper.breadcrumbArrow(graphics, x - 30, this.height - 51, 30, 20, 5, colors);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate(0.0f, 0.0f);
        if (this.backTrack.isHoveredOrFocused()) {
            Component component = this.backTrackingComponent();
            graphics.drawString(this.font, component, 41 - this.font.width((FormattedText)component) / 2, this.height - 16, ((Color)UIRenderHelper.COLOR_TEXT_DARKER.getFirst()).getRGB(), false);
            if (Mth.equal((float)this.arrowAnimation.getValue(), (float)this.arrowAnimation.getChaseTarget())) {
                this.arrowAnimation.setValue(1.0);
                this.arrowAnimation.setValue(1.0);
            }
        }
        poseStack.popMatrix();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderWindowBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.transition.getChaseTarget() == 0.0f || this.transition.settled()) {
            return;
        }
        Matrix3x2fStack ms = graphics.pose();
        Window window = this.minecraft.getWindow();
        float guiScaledWidth = window.getGuiScaledWidth();
        float guiScaledHeight = window.getGuiScaledHeight();
        Screen lastScreen = ScreenOpener.getPreviouslyRenderedScreen();
        float tValue = this.transition.getValue(partialTicks);
        float tValueAbsolute = Math.abs(tValue);
        float scale = tValue > 0.0f ? 1.0f - 0.5f * (1.0f - tValueAbsolute) : 1.0f + 0.5f * (1.0f - tValueAbsolute);
        int dpx = (int)(guiScaledWidth / 2.0f);
        int dpy = (int)(guiScaledHeight / 2.0f);
        ms.translate((float)dpx, (float)dpy);
        ms.scale(scale, scale);
        ms.translate((float)(-dpx), (float)(-dpy));
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        if (input.key() == 259) {
            ScreenOpener.openPreviousScreen(this, null);
            return true;
        }
        return super.keyPressed(input);
    }

    public void centerScalingOn(int x, int y) {
        this.depthPointX = x;
        this.depthPointY = y;
    }

    public void centerScalingOnMouse() {
        Window w = this.minecraft.getWindow();
        double mouseX = this.minecraft.mouseHandler.xpos() * (double)w.getGuiScaledWidth() / (double)w.getScreenWidth();
        double mouseY = this.minecraft.mouseHandler.ypos() * (double)w.getGuiScaledHeight() / (double)w.getScreenHeight();
        this.centerScalingOn((int)mouseX, (int)mouseY);
    }

    public boolean isEquivalentTo(NavigatableSimiScreen other) {
        return false;
    }

    public void shareContextWith(NavigatableSimiScreen other) {
    }

    protected void renderZeloBreadcrumbs(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        List<Screen> history = ScreenOpener.getScreenHistory();
        if (history.isEmpty()) {
            return;
        }
        history.add(0, this.minecraft.screen);
        int spacing = 20;
        ArrayList<String> names = new ArrayList<String>();
        for (Screen screen : history) {
            names.add(NavigatableSimiScreen.screenTitle(screen));
        }
        int bWidth = 0;
        for (String name : names) {
            bWidth += this.font.width(name) + spacing;
        }
        MutableInt mutableInt = new MutableInt(this.width - bWidth);
        MutableInt y = new MutableInt(this.height - 18);
        MutableBoolean first = new MutableBoolean(true);
        if (mutableInt.getValue() < 25) {
            mutableInt.setValue(25);
        }
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.translate(0.0f, 0.0f);
        names.forEach(s -> {
            int sWidth = this.font.width(s);
            UIRenderHelper.breadcrumbArrow(graphics, x.getValue(), y.getValue(), sWidth + spacing, 14, spacing / 2, new Color(-586149872), new Color(0x44101010));
            graphics.drawString(this.font, s, x.getValue() + 5, y.getValue() + 3, first.getValue() != false ? -1114130 : -2232577, true);
            first.setFalse();
            x.add(sWidth + spacing);
        });
        poseStack.popMatrix();
    }

    public static boolean isCurrentlyRenderingPreviousScreen() {
        return currentlyRenderingPreviousScreen;
    }

    private static String screenTitle(Screen screen) {
        if (screen instanceof NavigatableSimiScreen) {
            return ((NavigatableSimiScreen)screen).getBreadcrumbTitle();
        }
        return "<";
    }

    protected String getBreadcrumbTitle() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

