/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderState;
import com.zurrtum.create.client.catnip.gui.render.GpuTexture;
import com.zurrtum.create.client.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.BlitRenderState;
import net.minecraft.client.gui.render.state.GuiRenderState;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public class EntityBlockRenderer
extends PictureInPictureRenderer<EntityBlockRenderState> {
    private static final Int2ObjectMap<GpuTexture> TEXTURES = new Int2ObjectArrayMap();
    private static final CameraRenderState CAMERA = new CameraRenderState();
    private final PoseStack matrices = new PoseStack();
    private int windowScaleFactor;

    public EntityBlockRenderer(MultiBufferSource.BufferSource vertexConsumers) {
        super(vertexConsumers);
    }

    public static void clear(int key) {
        GpuTexture texture = (GpuTexture)TEXTURES.remove(key);
        if (texture != null) {
            texture.close();
        }
    }

    public void prepare(EntityBlockRenderState block, GuiRenderState state, int windowScaleFactor) {
        BlockEntityRenderer renderer;
        if (this.windowScaleFactor != windowScaleFactor) {
            this.windowScaleFactor = windowScaleFactor;
            TEXTURES.values().forEach(GpuTexture::close);
            TEXTURES.clear();
        }
        float size = block.size() * (float)windowScaleFactor;
        GpuTexture texture = (GpuTexture)TEXTURES.get(block.id());
        if (texture == null) {
            texture = GpuTexture.create((int)size);
            TEXTURES.put(block.id(), (Object)texture);
        }
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBuffer.getBuffer(size, size), (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        texture.prepare();
        this.matrices.pushPose();
        this.matrices.translate(size / 2.0f, size / 2.0f, 0.0f);
        float scale = block.scale() * (float)windowScaleFactor;
        this.matrices.scale(scale, -scale, scale);
        Minecraft mc = Minecraft.getInstance();
        GameRenderer gameRenderer = mc.gameRenderer;
        gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        if (block.zRot() != 0.0f) {
            this.matrices.mulPose((Quaternionfc)Axis.ZP.rotation(block.zRot()));
        }
        if (block.xRot() != 0.0f) {
            this.matrices.mulPose((Quaternionfc)Axis.XP.rotation(block.xRot()));
        }
        if (block.yRot() != 0.0f) {
            this.matrices.mulPose((Quaternionfc)Axis.YP.rotation(block.yRot()));
        }
        this.matrices.translate(-0.5f, -0.5f, -0.5f);
        BlockRenderDispatcher blockRenderManager = mc.getBlockRenderer();
        Level world = block.world();
        BlockState blockState = block.state();
        BlockEntity blockEntity = block.entity();
        RenderType layer = ItemBlockRenderTypes.getChunkRenderType((BlockState)blockState) == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentItemSheet() : Sheets.cutoutBlockSheet();
        SinglePosVirtualBlockGetter lightWorld = SinglePosVirtualBlockGetter.createFullBright();
        lightWorld.blockState(blockState);
        lightWorld.blockEntity(blockEntity);
        BlockStateModel model = blockRenderManager.getBlockModel(blockState);
        ObjectArrayList parts = new ObjectArrayList();
        RandomSource random = world.getRandom();
        BlockStateModel blockStateModel = WrapperBlockStateModel.unwrapCompat(model);
        if (blockStateModel instanceof WrapperBlockStateModel) {
            WrapperBlockStateModel wrapper = (WrapperBlockStateModel)blockStateModel;
            wrapper.addPartsWithInfo((BlockAndTintGetter)world, block.pos(), blockState, random, (List<BlockModelPart>)parts);
        } else {
            model.collectParts(random, (List)parts);
        }
        blockRenderManager.renderBatched(blockState, BlockPos.ZERO, (BlockAndTintGetter)lightWorld, this.matrices, this.bufferSource.getBuffer(layer), false, (List)parts);
        if (blockEntity != null && (renderer = mc.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
            FeatureRenderDispatcher renderDispatcher = gameRenderer.getFeatureRenderDispatcher();
            Level previousLevel = blockEntity.getLevel();
            BlockState stateBefore = blockEntity.getBlockState();
            blockEntity.setLevel(world);
            blockEntity.setBlockState(blockState);
            BlockEntityRenderState renderState = renderer.createRenderState();
            renderer.extractRenderState(blockEntity, renderState, 0.0f, EntityBlockRenderer.CAMERA.pos, null);
            renderer.submit(renderState, this.matrices, (SubmitNodeCollector)renderDispatcher.getSubmitNodeStorage(), CAMERA);
            renderDispatcher.renderAllFeatures();
            blockEntity.setBlockState(stateBefore);
            blockEntity.setLevel(previousLevel);
        }
        this.bufferSource.endBatch();
        this.matrices.popPose();
        texture.clear();
        state.submitBlitToCurrentLayer(new BlitRenderState(RenderPipelines.GUI_TEXTURED_PREMULTIPLIED_ALPHA, TextureSetup.singleTexture((GpuTextureView)texture.textureView(), (GpuSampler)RenderSystem.getSamplerCache().getRepeat(FilterMode.NEAREST)), block.pose(), block.x0(), block.y0(), block.x1(), block.y1(), 0.0f, 1.0f, 1.0f, 0.0f, -1, null, null));
    }

    protected void renderToTexture(EntityBlockRenderState state, PoseStack matrices) {
    }

    protected String getTextureLabel() {
        return "Entity Block";
    }

    public Class<EntityBlockRenderState> getRenderStateClass() {
        return EntityBlockRenderState.class;
    }
}

