/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.TrackingItemStackRenderState;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public record ItemTransformRenderState(TrackingItemStackRenderState state, Matrix3x2f pose, ScreenRectangle bounds, int x0, int y0, int x1, int y1, int padding, float scale, float xRot, float yRot, float zRot, @Nullable ScreenRectangle scissorArea) implements PictureInPictureRenderState
{
    public static ItemTransformRenderState create(GuiGraphics graphics, ItemStack stack, float x, float y, float scale, int padding, float xRot, float yRot, float zRot) {
        TrackingItemStackRenderState state = new TrackingItemStackRenderState();
        state.displayContext = ItemDisplayContext.GUI;
        state.appendModelIdentityElement((Object)Float.valueOf(scale));
        state.appendModelIdentityElement((Object)padding);
        state.appendModelIdentityElement((Object)Float.valueOf(xRot));
        state.appendModelIdentityElement((Object)Float.valueOf(yRot));
        state.appendModelIdentityElement((Object)Float.valueOf(zRot));
        Minecraft mc = graphics.minecraft;
        mc.getItemModelResolver().appendItemLayers((ItemStackRenderState)state, stack, state.displayContext, (Level)mc.level, (ItemOwner)mc.player, 0);
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)graphics.pose());
        float size = scale * 16.0f + (float)padding;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = (int)(x + size);
        int y2 = (int)(y + size);
        ScreenRectangle bounds = new ScreenRectangle(x1, y1, (int)size, (int)size).transformMaxBounds((Matrix3x2fc)pose);
        ScreenRectangle scissor = graphics.scissorStack.peek();
        if (scissor != null) {
            bounds = bounds.intersection(scissor);
        }
        return new ItemTransformRenderState(state, pose, bounds, x1, y1, x2, y2, padding, size, xRot, yRot, zRot, scissor);
    }

    public Object getKey() {
        return this.state.getModelIdentity();
    }
}

