/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.gui.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class PartialRenderState
implements PictureInPictureRenderState {
    public SimpleModelWrapper model;
    public boolean dirty;
    public Matrix3x2f IDENTITY_POSE;
    public ScreenRectangle bounds;
    public int x1;
    public int y1;
    public int x2;
    public int y2;
    public int padding;
    public float size;
    private BiConsumer<PoseStack, Float> transform;
    private float partialTicks;
    @Nullable
    public ScreenRectangle scissor;

    public void transform(PoseStack matrices) {
        if (this.transform != null) {
            this.transform.accept(matrices, Float.valueOf(this.partialTicks));
        }
    }

    public void update(GuiGraphics graphics, PartialModel partial, float x, float y, float xLocal, float yLocal, float scale, int padding, float partialTicks, BiConsumer<PoseStack, Float> transform) {
        float size = scale * 16.0f + (float)padding;
        if (this.model != partial.get()) {
            this.dirty = this.model != null;
            this.model = partial.get();
        } else if (size != this.size || partialTicks != this.partialTicks) {
            this.dirty = true;
        }
        this.IDENTITY_POSE = new Matrix3x2f((Matrix3x2fc)graphics.pose());
        this.IDENTITY_POSE.translate(xLocal, yLocal);
        this.x1 = (int)x;
        this.y1 = (int)y;
        this.x2 = (int)(x + size);
        this.y2 = (int)(y + size);
        this.bounds = new ScreenRectangle(this.x1, this.y1, (int)size, (int)size).transformMaxBounds((Matrix3x2fc)this.IDENTITY_POSE);
        this.scissor = graphics.scissorStack.peek();
        if (this.scissor != null) {
            this.bounds = this.bounds.intersection(this.scissor);
        }
        this.size = size;
        this.padding = padding;
        this.transform = transform;
        this.partialTicks = partialTicks;
    }

    public void clearDirty() {
        this.dirty = false;
    }

    public int x0() {
        return this.x1;
    }

    public int x1() {
        return this.x2;
    }

    public int y0() {
        return this.y1;
    }

    public int y1() {
        return this.y2;
    }

    public Matrix3x2f pose() {
        return this.IDENTITY_POSE;
    }

    @Nullable
    public ScreenRectangle bounds() {
        return this.bounds;
    }

    public float scale() {
        return this.size;
    }

    @Nullable
    public ScreenRectangle scissorArea() {
        return this.scissor;
    }
}

