/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.impl.client.render.model;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.zurrtum.create.client.catnip.client.render.model.ShadeSeparatedResultConsumer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import org.jetbrains.annotations.UnknownNullability;

class MeshEmitter {
    private final ChunkSectionLayer renderType;
    private final ByteBufferBuilder byteBufferBuilder;
    private @UnknownNullability BufferBuilder bufferBuilder;
    private @UnknownNullability ShadeSeparatedResultConsumer resultConsumer;
    private boolean currentShade;

    MeshEmitter(ChunkSectionLayer renderType) {
        this.renderType = renderType;
        this.byteBufferBuilder = new ByteBufferBuilder(renderType.bufferSize());
    }

    public void prepare(ShadeSeparatedResultConsumer resultConsumer) {
        this.resultConsumer = resultConsumer;
    }

    public void end() {
        if (this.bufferBuilder != null) {
            this.emit();
        }
        this.resultConsumer = null;
    }

    public BufferBuilder getBuffer(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (this.bufferBuilder == null) {
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        } else if (shade != this.currentShade) {
            this.emit();
            this.bufferBuilder = new BufferBuilder(this.byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
        }
        this.currentShade = shade;
    }

    private void emit() {
        MeshData data = this.bufferBuilder.build();
        this.bufferBuilder = null;
        if (data != null) {
            this.resultConsumer.accept(this.renderType, this.currentShade, data);
            data.close();
        }
    }
}

