/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.levelWrappers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class WrappedClientLevel
extends ClientLevel {
    private static final Minecraft mc = Minecraft.getInstance();
    protected Level level;

    public WrappedClientLevel(Level level) {
        super(mc.getConnection(), WrappedClientLevel.mc.level.getLevelData(), level.dimension(), level.dimensionTypeRegistration(), WrappedClientLevel.mc.getConnection().serverChunkRadius, WrappedClientLevel.mc.level.getServerSimulationDistance(), WrappedClientLevel.mc.levelRenderer, level.isDebug(), level.getBiomeManager().biomeZoomSeed, level.getSeaLevel());
        this.level = level;
    }

    public static WrappedClientLevel of(Level level) {
        return new WrappedClientLevel(level);
    }

    public boolean hasChunkAt(BlockPos pos) {
        return this.level.hasChunkAt(pos);
    }

    public boolean isLoaded(BlockPos pos) {
        return this.level.isLoaded(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.level.getBlockState(pos);
    }

    public BlockGetter getChunkForCollisions(int x, int z) {
        return this.level.getChunkForCollisions(x, z);
    }

    public int getBrightness(LightLayer type, BlockPos pos) {
        return this.level.getBrightness(type, pos);
    }

    public int getLightEmission(BlockPos pos) {
        return this.level.getLightEmission(pos);
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.level.getFluidState(pos);
    }

    public int getBlockTint(BlockPos p_225525_1_, ColorResolver p_225525_2_) {
        return this.level.getBlockTint(p_225525_1_, p_225525_2_);
    }

    public void addParticle(ParticleOptions p_195594_1_, double p_195594_2_, double p_195594_4_, double p_195594_6_, double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        this.level.addParticle(p_195594_1_, p_195594_2_, p_195594_4_, p_195594_6_, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    public void addParticle(ParticleOptions p_195590_1_, boolean p_195590_2_, boolean canSpawnOnMinimal, double p_195590_3_, double p_195590_5_, double p_195590_7_, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        this.level.addParticle(p_195590_1_, p_195590_2_, canSpawnOnMinimal, p_195590_3_, p_195590_5_, p_195590_7_, p_195590_9_, p_195590_11_, p_195590_13_);
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_195589_1_, double p_195589_2_, double p_195589_4_, double p_195589_6_, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        this.level.addAlwaysVisibleParticle(p_195589_1_, p_195589_2_, p_195589_4_, p_195589_6_, p_195589_8_, p_195589_10_, p_195589_12_);
    }

    public void addAlwaysVisibleParticle(ParticleOptions p_217404_1_, boolean p_217404_2_, double p_217404_3_, double p_217404_5_, double p_217404_7_, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        this.level.addAlwaysVisibleParticle(p_217404_1_, p_217404_2_, p_217404_3_, p_217404_5_, p_217404_7_, p_217404_9_, p_217404_11_, p_217404_13_);
    }

    public void playLocalSound(double p_184134_1_, double p_184134_3_, double p_184134_5_, SoundEvent p_184134_7_, SoundSource p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        this.level.playLocalSound(p_184134_1_, p_184134_3_, p_184134_5_, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_, p_184134_11_);
    }

    public void playSound(@Nullable Entity p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_, SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
        this.level.playSound(p_184148_1_, p_184148_2_, p_184148_4_, p_184148_6_, p_184148_8_, p_184148_9_, p_184148_10_, p_184148_11_);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos p_175625_1_) {
        return this.level.getBlockEntity(p_175625_1_);
    }

    public Level getWrappedLevel() {
        return this.level;
    }
}

