/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.catnip.outliner.Outline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ItemOutline
extends Outline {
    protected Vec3 pos;
    protected ItemStack stack;
    protected ItemStackRenderState itemRenderState;
    protected SubmitNodeStorage queue;
    protected PoseStack matrices;

    public ItemOutline(Vec3 pos, ItemStack stack) {
        this.pos = pos;
        this.stack = stack;
        this.itemRenderState = new ItemStackRenderState();
        this.matrices = new PoseStack();
        this.queue = new SubmitNodeStorage();
    }

    @Override
    public void render(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        ms.pushPose();
        ms.translate(this.pos.x - camera.x, this.pos.y - camera.y, this.pos.z - camera.z);
        ms.scale(this.params.alpha, this.params.alpha, this.params.alpha);
        mc.getItemModelResolver().updateForTopItem(this.itemRenderState, this.stack, ItemDisplayContext.FIXED, null, null, 0);
        this.itemRenderState.submit(ms, (SubmitNodeCollector)this.queue, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        for (SubmitNodeCollection batchingRenderCommandQueue : this.queue.getSubmitsPerOrder().values()) {
            for (SubmitNodeStorage.ItemSubmit itemCommand : batchingRenderCommandQueue.getItemSubmits()) {
                this.matrices.pushPose();
                this.matrices.last().set(itemCommand.pose());
                ItemRenderer.renderItem((ItemDisplayContext)itemCommand.displayContext(), (PoseStack)this.matrices, (MultiBufferSource)buffer, (int)itemCommand.lightCoords(), (int)itemCommand.overlayCoords(), (int[])itemCommand.tintLayers(), (List)itemCommand.quads(), (RenderType)itemCommand.renderType(), (ItemStackRenderState.FoilType)itemCommand.foilType());
                this.matrices.popPose();
            }
        }
        ms.popPose();
    }
}

