/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;

public class FluidRenderHelper {
    public static void renderFluidBox(Fluid fluid, DataComponentPatch changes, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidRenderHelper.renderFluidBox(fluid, changes, xMin, yMin, zMin, xMax, yMax, zMax, buffer.getBuffer(RenderTypes.translucentMovingBlock()), ms, light, renderBottom, invertGasses);
    }

    public static void renderFluidBox(Fluid fluid, DataComponentPatch changes, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        TextureAtlasSprite fluidTexture = config.still().get();
        int color = config.tint().apply(changes) | 0xFF000000;
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.defaultFluidState().createLegacyBlock().getLightEmission());
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.pushPose();
        if (invertGasses) {
            // empty if block
        }
        PoseStack.Pose entry = ms.last();
        for (Direction side : Iterate.directions) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    FluidRenderHelper.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, entry, light, color, fluidTexture);
                    continue;
                }
                FluidRenderHelper.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, entry, light, color, fluidTexture);
                continue;
            }
            FluidRenderHelper.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, entry, light, color, fluidTexture);
        }
        ms.popPose();
    }

    public static void renderFluidBox(Fluid fluid, DataComponentPatch changes, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack.Pose entry, int light, boolean renderBottom, boolean invertGasses) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        TextureAtlasSprite fluidTexture = config.still().get();
        int color = config.tint().apply(changes) | 0xFF000000;
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.defaultFluidState().createLegacyBlock().getLightEmission());
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        if (invertGasses) {
            // empty if block
        }
        for (Direction side : Iterate.directions) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.getAxisDirection() == Direction.AxisDirection.POSITIVE;
            if (side.getAxis().isHorizontal()) {
                if (side.getAxis() == Direction.Axis.X) {
                    FluidRenderHelper.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, entry, light, color, fluidTexture);
                    continue;
                }
                FluidRenderHelper.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, entry, light, color, fluidTexture);
                continue;
            }
            FluidRenderHelper.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, entry, light, color, fluidTexture);
        }
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack.Pose entry, int light, int color, TextureAtlasSprite texture) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, entry, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack.Pose entry, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.getAxisDirection() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.getAxis().isHorizontal();
        boolean x = dir.getAxis() == Direction.Axis.X;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.floor((float)x1);
            float x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.ceil((float)x2);
                u1 = texture.getU((f - x2) * textureScale);
                u2 = texture.getU((f - x1) * textureScale);
            } else {
                u1 = texture.getU((x1 - f) * textureScale);
                u2 = texture.getU((x2 - f) * textureScale);
            }
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.floor((float)y1);
                float y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.getV((y1 - f) * textureScale);
                    v2 = texture.getV((y2 - f) * textureScale);
                } else {
                    f = Mth.ceil((float)y2);
                    v1 = texture.getV((f - y2) * textureScale);
                    v2 = texture.getV((f - y1) * textureScale);
                }
                if (horizontal) {
                    if (x) {
                        FluidRenderHelper.putVertex(builder, entry, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        FluidRenderHelper.putVertex(builder, entry, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        FluidRenderHelper.putVertex(builder, entry, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    FluidRenderHelper.putVertex(builder, entry, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    FluidRenderHelper.putVertex(builder, entry, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, entry, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    FluidRenderHelper.putVertex(builder, entry, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    protected static void putVertex(VertexConsumer builder, PoseStack.Pose entry, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.getUnitVec3i();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.addVertex((Matrix4fc)entry.pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setLight(light).setNormal(entry, (float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
    }
}

