/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.catnip.render;

import com.zurrtum.create.client.catnip.render.StitchedSprite;
import java.util.Objects;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;

public class SpriteShiftEntry {
    @Nullable
    protected StitchedSprite original;
    @Nullable
    protected StitchedSprite target;

    public void set(Identifier originalLocation, Identifier targetLocation) {
        this.original = new StitchedSprite(originalLocation);
        this.target = new StitchedSprite(targetLocation);
    }

    public Identifier getOriginalIdentifier() {
        Objects.requireNonNull(this.original);
        return this.original.getLocation();
    }

    public Identifier getTargetIdentifier() {
        Objects.requireNonNull(this.target);
        return this.target.getLocation();
    }

    public TextureAtlasSprite getOriginal() {
        Objects.requireNonNull(this.original);
        return this.original.get();
    }

    public TextureAtlasSprite getTarget() {
        Objects.requireNonNull(this.target);
        return this.target.get();
    }

    public float getTargetU(float localU) {
        return this.getTarget().getU(SpriteShiftEntry.getUnInterpolatedU(this.getOriginal(), localU));
    }

    public float getTargetV(float localV) {
        return this.getTarget().getV(SpriteShiftEntry.getUnInterpolatedV(this.getOriginal(), localV));
    }

    public static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.getU1() - sprite.getU0();
        return (u - sprite.getU0()) / f;
    }

    public static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.getV1() - sprite.getV0();
        return (v - sprite.getV0()) / f;
    }
}

