/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllDamageSources;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.ContraptionCollider;
import com.zurrtum.create.content.contraptions.ControlledContraptionEntity;
import com.zurrtum.create.content.contraptions.TranslatingContraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.foundation.collision.ContinuousOBBCollider;
import com.zurrtum.create.foundation.collision.Matrix3d;
import com.zurrtum.create.foundation.collision.OrientedBB;
import com.zurrtum.create.foundation.utility.BlockHelper;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.ClientMotionPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionColliderLockPacketRequest;
import com.zurrtum.create.infrastructure.packet.c2s.TrainCollisionPacket;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContraptionColliderClient {
    private static MutablePair<WeakReference<AbstractContraptionEntity>, Double> safetyLock = new MutablePair();
    private static Map<AbstractContraptionEntity, Map<Player, Double>> remoteSafetyLocks = new WeakHashMap<AbstractContraptionEntity, Map<Player, Double>>();
    private static int packetCooldown = 0;

    static void collideEntities(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption == null) {
            return;
        }
        AABB bounds = contraptionEntity.getBoundingBox();
        if (bounds == null) {
            return;
        }
        Vec3 contraptionPosition = contraptionEntity.position();
        Vec3 contraptionMotion = contraptionPosition.subtract(contraptionEntity.getPrevPositionVec());
        Vec3 anchorVec = contraptionEntity.getAnchorVec();
        AbstractContraptionEntity.ContraptionRotationState rotation = null;
        if (ContraptionColliderClient.safetyLock.left != null && ((WeakReference)ContraptionColliderClient.safetyLock.left).get() == contraptionEntity) {
            ContraptionColliderClient.saveClientPlayerFromClipping(contraptionEntity, contraptionMotion);
        }
        boolean skipClientPlayer = false;
        Level world = contraptionEntity.level();
        List entitiesWithinAABB = world.getEntitiesOfClass(Entity.class, bounds.inflate(2.0).expandTowards(0.0, 32.0, 0.0), contraptionEntity::canCollideWith);
        for (Entity entity : entitiesWithinAABB) {
            double d1;
            double idealVerticalMotion;
            boolean anyCollision;
            Vec3 entityMotion;
            if (!entity.isAlive()) continue;
            ContraptionCollider.PlayerType playerType = ContraptionColliderClient.getPlayerType(entity);
            if (playerType == ContraptionCollider.PlayerType.REMOTE) {
                if (!(contraption instanceof TranslatingContraption)) continue;
                ContraptionColliderClient.saveRemotePlayerFromClipping((Player)entity, contraptionEntity, contraptionMotion);
                continue;
            }
            entity.getSelfAndPassengers().forEach(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer playerEntity = (ServerPlayer)e;
                    playerEntity.connection.aboveGroundTickCount = 0;
                }
            });
            if (playerType == ContraptionCollider.PlayerType.CLIENT) {
                if (skipClientPlayer) continue;
                skipClientPlayer = true;
            }
            if (rotation == null) {
                rotation = contraptionEntity.getRotationState();
            }
            Matrix3d rotationMatrix = rotation.asMatrix();
            Vec3 entityPosition = entity.position();
            AABB entityBounds = entity.getBoundingBox();
            Vec3 motion = entity.getDeltaMovement();
            float yawOffset = rotation.getYawOffset();
            Vec3 position = ContraptionCollider.getWorldToLocalTranslation(entity, anchorVec, rotationMatrix, yawOffset);
            if (playerType == ContraptionCollider.PlayerType.CLIENT && entityBounds.getYsize() > 1.0) {
                entityBounds = entityBounds.contract(0.0, 0.125, 0.0);
            }
            motion = motion.subtract(contraptionMotion);
            motion = rotationMatrix.transform(motion);
            AABB localBB = entityBounds.move(position).inflate(1.0E-7);
            OrientedBB obb = new OrientedBB(localBB);
            obb.setRotation(rotationMatrix);
            Vec3 motionCopy = motion;
            List collidableBBs = contraption.getSimplifiedEntityColliders().orElseGet(() -> {
                ArrayList bbs = new ArrayList();
                List<VoxelShape> potentialHits = ContraptionCollider.getPotentiallyCollidedShapes(world, contraption, localBB.expandTowards(motionCopy));
                potentialHits.forEach(shape -> bbs.addAll(shape.toAabbs()));
                return bbs;
            });
            MutableObject collisionResponse = new MutableObject((Object)Vec3.ZERO);
            MutableObject normal = new MutableObject((Object)Vec3.ZERO);
            MutableObject location = new MutableObject((Object)Vec3.ZERO);
            MutableBoolean surfaceCollision = new MutableBoolean(false);
            MutableFloat temporalResponse = new MutableFloat(1.0f);
            Vec3 obbCenter = obb.getCenter();
            boolean doHorizontalPass = !rotation.hasVerticalRotation();
            for (boolean horizontalPass : Iterate.trueAndFalse) {
                boolean noVerticalCollision;
                boolean verticalPass = !horizontalPass || !doHorizontalPass;
                for (AABB bb : collidableBBs) {
                    boolean nearest;
                    Vec3 separation;
                    double timeOfImpact;
                    Vec3 currentResponse = (Vec3)collisionResponse.getValue();
                    Vec3 currentCenter = obbCenter.add(currentResponse);
                    if (Math.abs(currentCenter.x - bb.getCenter().x) - entityBounds.getXsize() - 1.0 > bb.getXsize() / 2.0 || Math.abs(currentCenter.y + motion.y - bb.getCenter().y) - entityBounds.getYsize() - 1.0 > bb.getYsize() / 2.0 || Math.abs(currentCenter.z - bb.getCenter().z) - entityBounds.getZsize() - 1.0 > bb.getZsize() / 2.0) continue;
                    obb.setCenter(currentCenter);
                    ContinuousOBBCollider.ContinuousSeparationManifold intersect = obb.intersect(bb, motion);
                    if (intersect == null) continue;
                    if (verticalPass && surfaceCollision.isFalse()) {
                        surfaceCollision.setValue(intersect.isSurfaceCollision());
                    }
                    boolean isTemporal = (timeOfImpact = intersect.getTimeOfImpact()) > 0.0 && timeOfImpact < 1.0;
                    Vec3 collidingNormal = intersect.getCollisionNormal();
                    Vec3 collisionPosition = intersect.getCollisionPosition();
                    if (!isTemporal && (separation = intersect.asSeparationVec(entity.maxUpStep())) != null && !separation.equals((Object)Vec3.ZERO)) {
                        collisionResponse.setValue((Object)currentResponse.add(separation));
                        timeOfImpact = 0.0;
                    }
                    boolean bl = nearest = timeOfImpact >= 0.0 && (double)temporalResponse.getValue().floatValue() > timeOfImpact;
                    if (collidingNormal != null && nearest) {
                        normal.setValue((Object)collidingNormal);
                    }
                    if (collisionPosition != null && nearest) {
                        location.setValue((Object)collisionPosition);
                    }
                    if (!isTemporal || !((double)temporalResponse.getValue().floatValue() > timeOfImpact)) continue;
                    temporalResponse.setValue((Number)timeOfImpact);
                }
                if (verticalPass) break;
                boolean noVerticalMotionResponse = temporalResponse.getValue().floatValue() == 1.0f;
                boolean bl = noVerticalCollision = ((Vec3)collisionResponse.getValue()).y == 0.0;
                if (noVerticalCollision && noVerticalMotionResponse) break;
                collisionResponse.setValue((Object)((Vec3)collisionResponse.getValue()).multiply(1.0078125, 0.0, 1.0078125));
            }
            Vec3 entityMotionNoTemporal = entityMotion = entity.getDeltaMovement();
            Vec3 collisionNormal = (Vec3)normal.getValue();
            Vec3 collisionLocation = (Vec3)location.getValue();
            Vec3 totalResponse = (Vec3)collisionResponse.getValue();
            boolean hardCollision = !totalResponse.equals((Object)Vec3.ZERO);
            boolean temporalCollision = temporalResponse.getValue().floatValue() != 1.0f;
            Vec3 motionResponse = !temporalCollision ? motion : motion.normalize().scale(motion.length() * (double)temporalResponse.getValue().floatValue());
            rotationMatrix.transpose();
            motionResponse = rotationMatrix.transform(motionResponse).add(contraptionMotion);
            totalResponse = rotationMatrix.transform(totalResponse);
            totalResponse = VecHelper.rotate(totalResponse, yawOffset, Direction.Axis.Y);
            collisionNormal = rotationMatrix.transform(collisionNormal);
            collisionNormal = VecHelper.rotate(collisionNormal, yawOffset, Direction.Axis.Y);
            collisionNormal = collisionNormal.normalize();
            collisionLocation = rotationMatrix.transform(collisionLocation);
            collisionLocation = VecHelper.rotate(collisionLocation, yawOffset, Direction.Axis.Y);
            rotationMatrix.transpose();
            double bounce = 0.0;
            double slide = 0.0;
            if (!collisionLocation.equals((Object)Vec3.ZERO)) {
                BlockState blockState;
                collisionLocation = collisionLocation.add(entity.position().add(entity.getBoundingBox().getCenter()).scale(0.5));
                if (temporalCollision) {
                    collisionLocation = collisionLocation.add(0.0, motionResponse.y, 0.0);
                }
                BlockPos pos = BlockPos.containing((Position)contraptionEntity.toLocalVector(entity.position(), 0.0f));
                if (contraption.getBlocks().containsKey(pos) && (blockState = contraption.getBlocks().get(pos).state()).is(BlockTags.CLIMBABLE)) {
                    surfaceCollision.setTrue();
                    totalResponse = totalResponse.add(0.0, (double)0.1f, 0.0);
                }
                pos = BlockPos.containing((Position)contraptionEntity.toLocalVector(collisionLocation, 0.0f));
                if (contraption.getBlocks().containsKey(pos)) {
                    blockState = contraption.getBlocks().get(pos).state();
                    MovingInteractionBehaviour movingInteractionBehaviour = contraption.getInteractors().get(pos);
                    if (movingInteractionBehaviour != null) {
                        movingInteractionBehaviour.handleEntityCollision(entity, pos, contraptionEntity);
                    }
                    bounce = BlockHelper.getBounceMultiplier(blockState.getBlock());
                    slide = Math.max(0.0f, blockState.getBlock().getFriction() - 0.6f);
                }
            }
            boolean hasNormal = !collisionNormal.equals((Object)Vec3.ZERO);
            boolean bl = anyCollision = hardCollision || temporalCollision;
            if (bounce > 0.0 && hasNormal && anyCollision && ContraptionCollider.bounceEntity(entity, collisionNormal, contraptionEntity, bounce)) {
                entity.level().playSound((Entity)(playerType == ContraptionCollider.PlayerType.CLIENT ? entity : null), entity.getX(), entity.getY(), entity.getZ(), SoundEvents.SLIME_BLOCK_FALL, SoundSource.BLOCKS, 0.5f, 1.0f);
                continue;
            }
            if (temporalCollision && (idealVerticalMotion = motionResponse.y) != entityMotion.y) {
                entity.setDeltaMovement(entityMotion.multiply(1.0, 0.0, 1.0).add(0.0, idealVerticalMotion, 0.0));
                entityMotion = entity.getDeltaMovement();
            }
            if (hardCollision) {
                double motionX = entityMotion.x();
                double motionY = entityMotion.y();
                double motionZ = entityMotion.z();
                double intersectX = totalResponse.x();
                double intersectY = totalResponse.y();
                double intersectZ = totalResponse.z();
                double horizonalEpsilon = 0.0078125;
                if (motionX != 0.0 && Math.abs(intersectX) > horizonalEpsilon && motionX > 0.0 == intersectX < 0.0) {
                    entityMotion = entityMotion.multiply(0.0, 1.0, 1.0);
                }
                if (motionY != 0.0 && intersectY != 0.0 && motionY > 0.0 == intersectY < 0.0) {
                    entityMotion = entityMotion.multiply(1.0, 0.0, 1.0).add(0.0, contraptionMotion.y, 0.0);
                }
                if (motionZ != 0.0 && Math.abs(intersectZ) > horizonalEpsilon && motionZ > 0.0 == intersectZ < 0.0) {
                    entityMotion = entityMotion.multiply(1.0, 1.0, 0.0);
                }
            }
            if (bounce == 0.0 && slide > 0.0 && hasNormal && anyCollision && rotation.hasVerticalRotation()) {
                double slideFactor = collisionNormal.multiply(1.0, 0.0, 1.0).length() * 1.25;
                Vec3 motionIn = entityMotionNoTemporal.multiply(0.0, 0.9, 0.0).add(0.0, (double)-0.01f, 0.0);
                Vec3 slideNormal = collisionNormal.cross(motionIn.cross(collisionNormal)).normalize();
                Vec3 newMotion = entityMotion.multiply(0.85, 0.0, 0.85).add(slideNormal.scale(((double)0.2f + slide) * motionIn.length() * slideFactor).add(0.0, (double)-0.1f - collisionNormal.y * 0.125, 0.0));
                entity.setDeltaMovement(newMotion);
                entityMotion = entity.getDeltaMovement();
            }
            if (!hardCollision && surfaceCollision.isFalse()) continue;
            Vec3 allowedMovement = ContraptionCollider.collide(totalResponse, entity);
            entity.setPos(entityPosition.x + allowedMovement.x, entityPosition.y + allowedMovement.y, entityPosition.z + allowedMovement.z);
            entityPosition = entity.position();
            entityMotion = ContraptionColliderClient.handleDamageFromTrain(world, contraptionEntity, contraptionMotion, entity, entityMotion, playerType);
            entity.hurtMarked = true;
            Vec3 contactPointMotion = Vec3.ZERO;
            if (surfaceCollision.isTrue()) {
                boolean canWalk;
                contraptionEntity.registerColliding(entity);
                entity.fallDistance = 0.0;
                for (Entity rider : entity.getIndirectPassengers()) {
                    if (ContraptionColliderClient.getPlayerType(rider) != ContraptionCollider.PlayerType.CLIENT) continue;
                    Minecraft.getInstance().player.connection.send((Packet)new ClientMotionPacket(rider.getDeltaMovement(), true, 0.0f));
                }
                boolean bl2 = canWalk = bounce != 0.0 || slide == 0.0;
                if (canWalk || !rotation.hasVerticalRotation()) {
                    if (canWalk) {
                        entity.setOnGround(true);
                    }
                    if (entity instanceof ItemEntity) {
                        entityMotion = entityMotion.multiply(0.5, 1.0, 0.5);
                    }
                }
                contactPointMotion = contraptionEntity.getContactPointMotion(entityPosition);
                allowedMovement = ContraptionCollider.collide(contactPointMotion, entity);
                entity.setPos(entityPosition.x + allowedMovement.x, entityPosition.y, entityPosition.z + allowedMovement.z);
            }
            entity.setDeltaMovement(entityMotion);
            if (playerType != ContraptionCollider.PlayerType.CLIENT) continue;
            double d0 = entity.getX() - entity.xo - contactPointMotion.x;
            float limbSwing = Mth.sqrt((float)((float)(d0 * d0 + (d1 = entity.getZ() - entity.zo - contactPointMotion.z) * d1))) * 4.0f;
            if (limbSwing > 1.0f) {
                limbSwing = 1.0f;
            }
            Minecraft.getInstance().player.connection.send((Packet)new ClientMotionPacket(entityMotion, true, limbSwing));
            if (!entity.onGround() || !(contraption instanceof TranslatingContraption)) continue;
            safetyLock.setLeft(new WeakReference<AbstractContraptionEntity>(contraptionEntity));
            safetyLock.setRight((Object)(entity.getY() - contraptionEntity.getY()));
        }
    }

    private static Vec3 handleDamageFromTrain(Level world, AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion, Entity entity, Vec3 entityMotion, ContraptionCollider.PlayerType playerType) {
        Player p;
        if (!(contraptionEntity instanceof CarriageContraptionEntity)) {
            return entityMotion;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
        if (!entity.onGround()) {
            return entityMotion;
        }
        if (AllSynchedDatas.CONTRAPTION_GROUNDED.get(entity).booleanValue()) {
            AllSynchedDatas.CONTRAPTION_GROUNDED.set(entity, false);
            return entityMotion;
        }
        if (cce.collidingEntities.containsKey(entity)) {
            return entityMotion;
        }
        if (entity instanceof ItemEntity) {
            return entityMotion;
        }
        if (cce.nonDamageTicks != 0) {
            return entityMotion;
        }
        if (!((Boolean)AllConfigs.server().trains.trainsCauseDamage.get()).booleanValue()) {
            return entityMotion;
        }
        Vec3 diffMotion = contraptionMotion.subtract(entity.getDeltaMovement());
        if (diffMotion.length() <= (double)0.35f || contraptionMotion.length() <= (double)0.35f) {
            return entityMotion;
        }
        DamageSource source = AllDamageSources.get(world).runOver(contraptionEntity);
        double damage = diffMotion.length();
        if (entity.getType().getCategory() == MobCategory.MONSTER) {
            damage *= 2.0;
        }
        if (entity instanceof Player && ((p = (Player)entity).isCreative() || p.isSpectator())) {
            return entityMotion;
        }
        if (playerType == ContraptionCollider.PlayerType.CLIENT) {
            ((LocalPlayer)entity).connection.send((Packet)new TrainCollisionPacket((int)(damage * 16.0), contraptionEntity.getId()));
            world.playSound(entity, entity.blockPosition(), SoundEvents.PLAYER_ATTACK_CRIT, SoundSource.NEUTRAL, 1.0f, 0.75f);
        }
        Vec3 added = entityMotion.add(contraptionMotion.multiply(1.0, 0.0, 1.0).normalize().add(0.0, 0.25, 0.0).scale(damage * 4.0)).add(diffMotion);
        return VecHelper.clamp(added, 3.0f);
    }

    private static void saveClientPlayerFromClipping(AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion) {
        LocalPlayer entity = Minecraft.getInstance().player;
        if (entity.isPassenger()) {
            return;
        }
        double prevDiff = (Double)ContraptionColliderClient.safetyLock.right;
        double currentDiff = entity.getY() - contraptionEntity.getY();
        double motion = contraptionMotion.subtract((Vec3)entity.getDeltaMovement()).y;
        double trend = Math.signum(currentDiff - prevDiff);
        ClientPacketListener handler = entity.connection;
        if (handler.getOnlinePlayers().size() > 1) {
            if (packetCooldown > 0) {
                --packetCooldown;
            }
            if (packetCooldown == 0) {
                handler.send((Packet)new ContraptionColliderLockPacketRequest(contraptionEntity.getId(), currentDiff));
                packetCooldown = 3;
            }
        }
        if (trend == 0.0) {
            return;
        }
        if (trend == Math.signum(motion)) {
            return;
        }
        double speed = contraptionMotion.multiply(0.0, 1.0, 0.0).lengthSqr();
        if (trend > 0.0 && speed < 0.1) {
            return;
        }
        if (speed < 0.05) {
            return;
        }
        if (!ContraptionColliderClient.savePlayerFromClipping((Player)entity, contraptionEntity, contraptionMotion, prevDiff)) {
            safetyLock.setLeft(null);
        }
    }

    public static void lockPacketReceived(int contraptionId, int remotePlayerId, double suggestedOffset) {
        ClientLevel level = Minecraft.getInstance().level;
        Entity entity = level.getEntity(contraptionId);
        if (!(entity instanceof ControlledContraptionEntity)) {
            return;
        }
        ControlledContraptionEntity contraptionEntity = (ControlledContraptionEntity)entity;
        Entity entity2 = level.getEntity(remotePlayerId);
        if (!(entity2 instanceof RemotePlayer)) {
            return;
        }
        RemotePlayer player = (RemotePlayer)entity2;
        remoteSafetyLocks.computeIfAbsent(contraptionEntity, $ -> new WeakHashMap()).put(player, suggestedOffset);
    }

    private static void saveRemotePlayerFromClipping(Player entity, AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion) {
        if (entity.isPassenger()) {
            return;
        }
        Map locksOnThisContraption = remoteSafetyLocks.getOrDefault((Object)contraptionEntity, Collections.emptyMap());
        double prevDiff = locksOnThisContraption.getOrDefault(entity, entity.getY() - contraptionEntity.getY());
        if (!ContraptionColliderClient.savePlayerFromClipping(entity, contraptionEntity, contraptionMotion, prevDiff) && locksOnThisContraption.containsKey(entity)) {
            locksOnThisContraption.remove(entity);
        }
    }

    private static boolean savePlayerFromClipping(Player entity, AbstractContraptionEntity contraptionEntity, Vec3 contraptionMotion, double yStartOffset) {
        AABB bb = entity.getBoundingBox().deflate(0.25, 0.0, 0.25);
        double shortestDistance = Double.MAX_VALUE;
        double yStart = (double)entity.maxUpStep() + contraptionEntity.getY() + yStartOffset;
        double rayLength = Math.max(5.0, Math.abs(entity.getY() - yStart));
        for (int rayIndex = 0; rayIndex < 4; ++rayIndex) {
            Vec3 end;
            Vec3 start = new Vec3(rayIndex / 2 == 0 ? bb.minX : bb.maxX, yStart, rayIndex % 2 == 0 ? bb.minZ : bb.maxZ);
            BlockHitResult hitResult = ContraptionHandlerClient.rayTraceContraption(start, end = start.add(0.0, -rayLength, 0.0), contraptionEntity);
            if (hitResult == null) continue;
            Vec3 hit = contraptionEntity.toGlobalVector(hitResult.getLocation(), 1.0f);
            double hitDiff = start.y - hit.y;
            if (!(shortestDistance > hitDiff)) continue;
            shortestDistance = hitDiff;
        }
        if (shortestDistance > rayLength) {
            return false;
        }
        entity.setPos(entity.getX(), yStart - shortestDistance, entity.getZ());
        return true;
    }

    private static ContraptionCollider.PlayerType getPlayerType(Entity entity) {
        if (!(entity instanceof Player)) {
            return ContraptionCollider.PlayerType.NONE;
        }
        return entity instanceof LocalPlayer ? ContraptionCollider.PlayerType.CLIENT : ContraptionCollider.PlayerType.REMOTE;
    }
}

