/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSynchedDatas;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.contraptions.ContraptionColliderClient;
import com.zurrtum.create.client.content.trains.entity.TrainRelocatorClient;
import com.zurrtum.create.client.foundation.utility.RaycastHelper;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.infrastructure.packet.c2s.ContraptionInteractionPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;

public class ContraptionHandlerClient {
    public static WorldAttached<Map<Integer, WeakReference<AbstractContraptionEntity>>> loadedContraptions = new WorldAttached<Map>($ -> new HashMap());
    static WorldAttached<List<AbstractContraptionEntity>> queuedAdditions = new WorldAttached<List>($ -> ObjectLists.synchronize((ObjectList)new ObjectArrayList()));

    public static void tick(Level world) {
        Map<Integer, WeakReference<AbstractContraptionEntity>> map = loadedContraptions.get((LevelAccessor)world);
        List<AbstractContraptionEntity> queued = queuedAdditions.get((LevelAccessor)world);
        for (AbstractContraptionEntity contraptionEntity : queued) {
            map.put(contraptionEntity.getId(), new WeakReference<AbstractContraptionEntity>(contraptionEntity));
        }
        queued.clear();
        Collection<WeakReference<AbstractContraptionEntity>> values = map.values();
        Iterator<WeakReference<AbstractContraptionEntity>> iterator = values.iterator();
        while (iterator.hasNext()) {
            WeakReference<AbstractContraptionEntity> weakReference = iterator.next();
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)weakReference.get());
            if (contraptionEntity == null || !contraptionEntity.isAliveOrStale()) {
                iterator.remove();
                continue;
            }
            if (!contraptionEntity.isAlive()) {
                --contraptionEntity.staleTicks;
                continue;
            }
            ContraptionColliderClient.collideEntities(contraptionEntity);
        }
    }

    public static void addSpawnedContraptionsToCollisionList(Entity entity, Level world) {
        if (entity instanceof AbstractContraptionEntity) {
            queuedAdditions.get((LevelAccessor)world).add((AbstractContraptionEntity)entity);
        }
    }

    public static void entitiesWhoJustDismountedGetSentToTheRightLocation(LivingEntity entityLiving, Level world) {
        if (!world.isClientSide()) {
            return;
        }
        AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.get((Entity)entityLiving).ifPresent(position -> {
            if (entityLiving.getVehicle() == null) {
                entityLiving.absSnapTo(position.x, position.y, position.z, entityLiving.getYRot(), entityLiving.getXRot());
            }
            AllSynchedDatas.CONTRAPTION_DISMOUNT_LOCATION.set((Entity)entityLiving, Optional.empty());
            entityLiving.setOnGround(false);
        });
    }

    public static void preventRemotePlayersWalkingAnimations(RemotePlayer remotePlayer) {
        int lastOverride = AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.get((Entity)remotePlayer);
        if (lastOverride == -1) {
            return;
        }
        if (lastOverride > 5) {
            AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set((Entity)remotePlayer, -1);
            AllSynchedDatas.OVERRIDE_LIMB_SWING.set((Entity)remotePlayer, Float.valueOf(0.0f));
            return;
        }
        AllSynchedDatas.LAST_OVERRIDE_LIMB_SWING_UPDATE.set((Entity)remotePlayer, lastOverride + 1);
        float limbSwing = AllSynchedDatas.OVERRIDE_LIMB_SWING.get((Entity)remotePlayer).floatValue();
        remotePlayer.xo = remotePlayer.getX() - (double)(limbSwing / 4.0f);
        remotePlayer.zo = remotePlayer.getZ();
    }

    public static boolean rightClickingOnContraptionsGetsHandledLocally(Minecraft mc, InteractionHand hand) {
        LocalPlayer player = mc.player;
        if (player == null) {
            return false;
        }
        if (player.isSpectator()) {
            return false;
        }
        if (mc.level == null) {
            return false;
        }
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        AABB aabb = new AABB(origin, target).inflate(16.0);
        Collection<WeakReference<AbstractContraptionEntity>> contraptions = loadedContraptions.get((LevelAccessor)mc.level).values();
        double bestDistance = Double.MAX_VALUE;
        BlockHitResult bestResult = null;
        AbstractContraptionEntity bestEntity = null;
        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            double distance;
            BlockHitResult rayTraceResult;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !contraptionEntity.getBoundingBox().intersects(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null || (distance = contraptionEntity.toGlobalVector(rayTraceResult.getLocation(), 1.0f).distanceTo(origin)) > bestDistance) continue;
            bestResult = rayTraceResult;
            bestDistance = distance;
            bestEntity = contraptionEntity;
        }
        if (bestResult == null) {
            return false;
        }
        Direction face = bestResult.getDirection();
        BlockPos pos = bestResult.getBlockPos();
        if (bestEntity.handlePlayerInteraction((Player)player, pos, face, hand)) {
            player.connection.send((Packet)new ContraptionInteractionPacket(bestEntity, hand, pos, face));
        } else {
            ContraptionHandlerClient.handleSpecialInteractions(bestEntity, (Player)player, pos, face, hand);
        }
        return true;
    }

    private static boolean handleSpecialInteractions(AbstractContraptionEntity contraptionEntity, Player player, BlockPos localPos, Direction side, InteractionHand interactionHand) {
        if (player.getItemInHand(interactionHand).is((Item)AllItems.WRENCH) && contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity car = (CarriageContraptionEntity)contraptionEntity;
            return TrainRelocatorClient.carriageWrenched(car.toGlobalVector(VecHelper.getCenterOf((Vec3i)localPos), 1.0f), car);
        }
        return false;
    }

    public static Couple<Vec3> getRayInputs(Minecraft mc, LocalPlayer player) {
        Vec3 origin = player.getEyePosition();
        double reach = player.blockInteractionRange();
        if (mc.hitResult != null && mc.hitResult.getLocation() != null) {
            reach = Math.min(mc.hitResult.getLocation().distanceTo(origin), reach);
        }
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, reach, origin);
        return Couple.create(origin, target);
    }

    @Nullable
    public static BlockHitResult rayTraceContraption(Vec3 origin, Vec3 target, AbstractContraptionEntity contraptionEntity) {
        MutableObject mutableResult;
        Contraption contraption;
        Vec3 localTarget;
        Vec3 localOrigin = contraptionEntity.toLocalVector(origin, 1.0f);
        RaycastHelper.PredicateTraceResult predicateResult = RaycastHelper.rayTraceUntil(localOrigin, localTarget = contraptionEntity.toLocalVector(target, 1.0f), arg_0 -> ContraptionHandlerClient.lambda$rayTraceContraption$3(contraption = contraptionEntity.getContraption(), localOrigin, localTarget, mutableResult = new MutableObject(), arg_0));
        if (predicateResult == null || predicateResult.missed()) {
            return null;
        }
        BlockHitResult rayTraceResult = (BlockHitResult)mutableResult.getValue();
        return rayTraceResult;
    }

    private static /* synthetic */ boolean lambda$rayTraceContraption$3(Contraption contraption, Vec3 localOrigin, Vec3 localTarget, MutableObject mutableResult, BlockPos p) {
        for (Direction d : Iterate.directions) {
            BlockHitResult rayTrace;
            BlockState state;
            VoxelShape raytraceShape;
            if (d == Direction.UP) continue;
            BlockPos pos = d == Direction.DOWN ? p : p.relative(d);
            StructureTemplate.StructureBlockInfo blockInfo = contraption.getBlocks().get(pos);
            if (blockInfo == null || (raytraceShape = (state = blockInfo.state()).getShape((BlockGetter)contraption.getContraptionWorld(), BlockPos.ZERO.below())).isEmpty() || contraption.isHiddenInPortal(pos) || (rayTrace = raytraceShape.clip(localOrigin, localTarget, pos)) == null) continue;
            mutableResult.setValue((Object)rayTrace);
            return true;
        }
        return false;
    }
}

