/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.harvester;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvesterActorVisual
extends ActorVisual {
    static float originOffset = 0.0625f;
    static Vec3 rotOffset = new Vec3(0.5, (double)(-2.0f * originOffset + 0.5f), (double)(originOffset + 0.5f));
    protected TransformedInstance harvester;
    private final Direction facing;
    protected float horizontalAngle;
    private double rotation;
    private double previousRotation;

    public HarvesterActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        super(visualizationContext, (BlockAndTintGetter)simulationWorld, movementContext);
        BlockState state = movementContext.state;
        this.facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        this.harvester = this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial(this.getRollingPartial())).createInstance();
        this.horizontalAngle = this.facing.toYRot() + (float)(this.facing.getAxis() == Direction.Axis.X ? 180 : 0);
        this.harvester.light(this.localBlockLight(), 0);
        this.harvester.setChanged();
    }

    protected PartialModel getRollingPartial() {
        return AllPartialModels.HARVESTER_BLADE;
    }

    protected Vec3 getRotationOffset() {
        return rotOffset;
    }

    protected double getRadius() {
        return 6.5;
    }

    @Override
    public void tick() {
        super.tick();
        this.previousRotation = this.rotation;
        if (this.context.contraption.stalled || this.context.disabled || VecHelper.isVecPointingTowards(this.context.relativeMotion, this.facing.getOpposite())) {
            return;
        }
        double arcLength = this.context.motion.length();
        double radians = arcLength * 16.0 / this.getRadius();
        float deg = AngleHelper.deg(radians);
        deg = (int)(deg * 3000.0f) / 3000;
        this.rotation += (double)deg * 1.25;
        this.rotation %= 360.0;
    }

    @Override
    public void beginFrame() {
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.harvester.setIdentityTransform().translate((Vec3i)this.context.localPos)).center()).rotateYDegrees(this.horizontalAngle)).uncenter()).translate(this.getRotationOffset())).rotateXDegrees((float)this.getRotation())).translateBack(this.getRotationOffset())).setChanged();
    }

    @Override
    protected void _delete() {
        this.harvester.delete();
    }

    protected double getRotation() {
        return AngleHelper.angleLerp(AnimationTickHolder.getPartialTicks(), this.previousRotation, this.rotation);
    }
}

