/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.harvester;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.zurrtum.create.content.contraptions.actors.harvester.HarvesterBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HarvesterRenderer
implements BlockEntityRenderer<HarvesterBlockEntity, HarvesterRenderState> {
    public static final Vec3 PIVOT = new Vec3(0.0, 6.0, 9.0);

    public HarvesterRenderer(BlockEntityRendererProvider.Context context) {
    }

    public HarvesterRenderState createRenderState() {
        return new HarvesterRenderState();
    }

    public void extractRenderState(HarvesterBlockEntity be, HarvesterRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.model = CachedBuffers.partial(AllPartialModels.HARVESTER_BLADE, state.blockState);
        float originOffset = 0.0625f;
        state.rotOffset = new Vec3(0.0, HarvesterRenderer.PIVOT.y * (double)originOffset, HarvesterRenderer.PIVOT.z * (double)originOffset);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) / 20.0f;
        state.angle = AngleHelper.rad(time * be.getAnimatedSpeed() % 360.0f);
        state.horizontalAngle = AngleHelper.rad(AngleHelper.horizontalAngle((Direction)state.blockState.getValue((Property)HarvesterBlock.FACING)));
    }

    public void submit(HarvesterRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class HarvesterRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float angle;
        public Vec3 rotOffset;
        public float horizontalAngle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.rotateCentered(this.horizontalAngle, Direction.UP);
            this.model.translate(this.rotOffset.x, this.rotOffset.y, this.rotOffset.z);
            this.model.rotate(this.angle, Direction.WEST);
            this.model.translate(-this.rotOffset.x, -this.rotOffset.y, -this.rotOffset.z);
            this.model.light(this.lightCoords);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

