/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.roller;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlock;
import com.zurrtum.create.content.contraptions.actors.roller.RollerBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RollerRenderer
extends SmartBlockEntityRenderer<RollerBlockEntity, RollerRenderState> {
    public RollerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public RollerRenderState createRenderState() {
        return new RollerRenderState();
    }

    @Override
    public void extractRenderState(RollerBlockEntity be, RollerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.wheel = CachedBuffers.partial(AllPartialModels.ROLLER_WHEEL, state.blockState);
        Direction facing = (Direction)state.blockState.getValue((Property)RollerBlock.FACING);
        state.offset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(1.0625).add(0.0, -0.25, 0.0);
        float angle = AngleHelper.horizontalAngle(facing);
        state.wheelAngle = AngleHelper.rad(angle);
        Level world = be.getLevel();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world) / 20.0f;
        state.rotate = AngleHelper.rad(time * be.getAnimatedSpeed() % 360.0f);
        state.yRot = 1.5707964f;
        state.frame = CachedBuffers.partial(AllPartialModels.ROLLER_FRAME, state.blockState);
        state.frameAngle = AngleHelper.rad(angle + 180.0f);
    }

    @Override
    public void submit(RollerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class RollerRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer wheel;
        public Vec3 offset;
        public float wheelAngle;
        public float rotate;
        public float yRot;
        public SuperByteBuffer frame;
        public float frameAngle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.wheel.translate(this.offset)).rotateCentered(this.wheelAngle, Direction.UP)).rotate(this.rotate, Direction.WEST)).translate(0.0, -0.5, 0.5)).rotateY(this.yRot)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.frame.rotateCentered(this.frameAngle, Direction.UP)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

