/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.seat;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ContraptionPlayerPassengerRotation {
    static boolean active;
    static int prevId;
    static float prevYaw;
    static float prevPitch;

    public static void tick() {
        active = (Boolean)AllConfigs.client().rotateWhenSeated.get();
    }

    public static void frame(Minecraft client) {
        float pitch;
        float f;
        LocalPlayer player = client.player;
        if (!active) {
            return;
        }
        if (player == null || !player.isPassenger()) {
            prevId = 0;
            return;
        }
        Entity vehicle = player.getVehicle();
        if (!(vehicle instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)vehicle;
        AbstractContraptionEntity.ContraptionRotationState rotationState = contraptionEntity.getRotationState();
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
            f = cce.getViewYRot(AnimationTickHolder.getPartialTicks());
        } else {
            f = rotationState.yRotation;
        }
        float yaw = AngleHelper.wrapAngle180(f);
        if (contraptionEntity instanceof CarriageContraptionEntity) {
            CarriageContraptionEntity cce = (CarriageContraptionEntity)contraptionEntity;
            v1 = cce.getViewXRot(AnimationTickHolder.getPartialTicks());
        } else {
            v1 = pitch = 0.0f;
        }
        if (prevId != contraptionEntity.getId()) {
            prevId = contraptionEntity.getId();
            prevYaw = yaw;
            prevPitch = pitch;
        }
        float yawDiff = AngleHelper.getShortestAngleDiff(yaw, prevYaw);
        float pitchDiff = AngleHelper.getShortestAngleDiff(pitch, prevPitch);
        prevYaw = yaw;
        prevPitch = pitch;
        float playerYaw = player.getYRot();
        float yawRelativeToTrain = Mth.abs((float)AngleHelper.getShortestAngleDiff(playerYaw, -yaw - 90.0f));
        if (yawRelativeToTrain > 120.0f) {
            pitchDiff *= -1.0f;
        } else if (yawRelativeToTrain > 60.0f) {
            pitchDiff *= 0.0f;
        }
        player.setYRot(playerYaw + yawDiff);
        player.setXRot(player.getXRot() + pitchDiff);
    }
}

