/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.trainControls;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.infrastructure.packet.c2s.ControlsInputPacket;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import org.jetbrains.annotations.Nullable;

public class ControlsHandler {
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    public static int PACKET_RATE = 5;
    private static int packetCooldown;
    private static WeakReference<AbstractContraptionEntity> entityRef;
    private static BlockPos controlsPos;

    public static void levelUnloaded() {
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
    }

    public static void startControlling(LocalPlayer player, AbstractContraptionEntity entity, BlockPos controllerLocalPos) {
        entityRef = new WeakReference<AbstractContraptionEntity>(entity);
        controlsPos = controllerLocalPos;
        player.displayClientMessage((Component)CreateLang.translateDirect("contraption.controls.start_controlling", entity.getContraptionName()), true);
    }

    public static void stopControlling(LocalPlayer player) {
        ControlsUtil.getControls().forEach(kb -> kb.setDown(ControlsUtil.isActuallyPressed(kb)));
        AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)((Object)entityRef.get());
        if (!currentlyPressed.isEmpty() && abstractContraptionEntity != null) {
            player.connection.send((Packet)new ControlsInputPacket(currentlyPressed, false, abstractContraptionEntity.getId(), controlsPos, false));
        }
        packetCooldown = 0;
        entityRef = new WeakReference<Object>(null);
        controlsPos = null;
        currentlyPressed.clear();
        player.displayClientMessage((Component)CreateLang.translateDirect("contraption.controls.stop_controlling", new Object[0]), true);
    }

    public static void tick(Minecraft mc) {
        AbstractContraptionEntity entity = (AbstractContraptionEntity)((Object)entityRef.get());
        if (entity == null) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        if (entity.isRemoved() || InputConstants.isKeyDown((Window)mc.getWindow(), (int)256)) {
            BlockPos pos = controlsPos;
            ControlsHandler.stopControlling(mc.player);
            mc.player.connection.send((Packet)new ControlsInputPacket(currentlyPressed, false, entity.getId(), pos, true));
            return;
        }
        List<KeyMapping> controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (!releasedKeys.isEmpty()) {
            mc.player.connection.send((Packet)new ControlsInputPacket(releasedKeys, false, entity.getId(), controlsPos, false));
        }
        if (!newKeys.isEmpty()) {
            mc.player.connection.send((Packet)new ControlsInputPacket(newKeys, true, entity.getId(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        if (packetCooldown == 0) {
            mc.player.connection.send((Packet)new ControlsInputPacket(pressedKeys, true, entity.getId(), controlsPos, false));
            packetCooldown = PACKET_RATE;
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.setDown(false));
    }

    @Nullable
    public static AbstractContraptionEntity getContraption() {
        return (AbstractContraptionEntity)((Object)entityRef.get());
    }

    @Nullable
    public static BlockPos getControlsPos() {
        return controlsPos;
    }

    static {
        entityRef = new WeakReference<Object>(null);
    }
}

