/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.actors.trainControls;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.actors.trainControls.ControlsHandler;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.zurrtum.create.content.contraptions.actors.trainControls.ControlsMovementBehaviour;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import java.util.Collection;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ControlsMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        Object object = context.temporaryData;
        if (!(object instanceof ControlsMovementBehaviour.LeverAngles)) {
            return null;
        }
        ControlsMovementBehaviour.LeverAngles angles = (ControlsMovementBehaviour.LeverAngles)object;
        AbstractContraptionEntity entity = context.contraption.entity;
        if (!(entity instanceof CarriageContraptionEntity)) {
            return null;
        }
        CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
        BlockState blockState = context.state;
        Direction facing = (Direction)blockState.getValue((Property)ControlsBlock.FACING);
        if (ControlsHandler.getContraption() == entity && ControlsHandler.getControlsPos() != null && ControlsHandler.getControlsPos().equals((Object)context.localPos)) {
            Collection<Integer> pressed = ControlsHandler.currentlyPressed;
            angles.equipAnimation.chase(1.0, 0.2f, LerpedFloat.Chaser.EXP);
            angles.steering.chase((pressed.contains(3) ? 1 : 0) + (pressed.contains(2) ? -1 : 0), 0.2f, LerpedFloat.Chaser.EXP);
            Direction initialOrientation = cce.getInitialOrientation().getCounterClockWise();
            float f = cce.movingBackwards ^ !facing.equals((Object)initialOrientation) ? -1.0f : 1.0f;
            angles.speed.chase(Math.min(context.motion.length(), 0.5) * (double)f, 0.2f, LerpedFloat.Chaser.EXP);
        } else {
            angles.equipAnimation.chase(0.0, 0.2f, LerpedFloat.Chaser.EXP);
            angles.steering.chase(0.0, 0.0, LerpedFloat.Chaser.EXP);
            angles.speed.chase(0.0, 0.0, LerpedFloat.Chaser.EXP);
        }
        float pt = AnimationTickHolder.getPartialTicks((LevelAccessor)context.world);
        ControlsMovementRenderState state = new ControlsMovementRenderState(context.localPos);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.cover = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_COVER, blockState);
        state.lever = CachedBuffers.partial(AllPartialModels.TRAIN_CONTROLS_LEVER, blockState);
        state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle(facing));
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        float equipAnimation = angles.equipAnimation.getValue(pt);
        float firstLever = angles.speed.getValue(pt);
        float secondLever = angles.steering.getValue(pt);
        state.offsetY = Mth.lerp((float)(equipAnimation * equipAnimation), (float)-0.15f, (float)0.05f);
        state.firstAngle = (float)Math.PI / 180 * (Mth.clamp((float)(firstLever * 70.0f - 25.0f), (float)-45.0f, (float)45.0f) - 45.0f);
        state.secondAngle = (float)Math.PI / 180 * (Mth.clamp((float)(secondLever * 15.0f), (float)-45.0f, (float)45.0f) - 45.0f);
        state.xRot = 0.7853982f;
        return state;
    }

    public static class ControlsMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer cover;
        public SuperByteBuffer lever;
        public float yRot;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;
        public float offsetY;
        public float firstAngle;
        public float secondAngle;
        public float xRot;

        public ControlsMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cover.center()).rotateY(this.yRot)).uncenter()).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.lever.center()).rotateY(this.yRot)).translate(0.0f, 0.25f, 0.25f)).rotateX(this.firstAngle)).translate(0.0f, this.offsetY, 0.0f)).rotateX(this.xRot)).uncenter()).translate(0.0f, -0.375f, -0.1875f)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.lever.center()).rotateY(this.yRot)).translate(0.0f, 0.25f, 0.25f)).rotateX(this.secondAngle)).translate(0.0f, this.offsetY, 0.0f)).rotateX(this.xRot)).uncenter()).translate(0.375f, -0.375f, -0.1875f)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

