/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.content.contraptions.ContraptionHandlerClient;
import com.zurrtum.create.client.content.contraptions.actors.contraptionControls.ControlsSlot;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.actors.contraptionControls.ContraptionControlsMovement;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.contraptions.elevator.ElevatorContraption;
import java.lang.ref.WeakReference;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.MutablePair;

public class ElevatorControlsHandler {
    private static final ControlsSlot slot = new ElevatorControlsSlot();

    public static boolean onScroll(Minecraft mc, double delta) {
        ClientLevel world = mc.level;
        if (world == null) {
            return false;
        }
        LocalPlayer player = mc.player;
        Couple<Vec3> rayInputs = ContraptionHandlerClient.getRayInputs(mc, player);
        Vec3 origin = (Vec3)rayInputs.getFirst();
        Vec3 target = (Vec3)rayInputs.getSecond();
        AABB aabb = new AABB(origin, target).inflate(16.0);
        Collection<WeakReference<AbstractContraptionEntity>> contraptions = ContraptionHandlerClient.loadedContraptions.get((LevelAccessor)world).values();
        for (WeakReference<AbstractContraptionEntity> ref : contraptions) {
            BlockHitResult rayTraceResult;
            Contraption contraption;
            AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)((Object)ref.get());
            if (contraptionEntity == null || !((contraption = contraptionEntity.getContraption()) instanceof ElevatorContraption)) continue;
            ElevatorContraption ec = (ElevatorContraption)contraption;
            if (!contraptionEntity.getBoundingBox().intersects(aabb) || (rayTraceResult = ContraptionHandlerClient.rayTraceContraption(origin, target, contraptionEntity)) == null) continue;
            BlockPos pos = rayTraceResult.getBlockPos();
            StructureTemplate.StructureBlockInfo info = contraption.getBlocks().get(pos);
            if (info == null || !info.state().is((Block)AllBlocks.CONTRAPTION_CONTROLS) || !slot.testHit((LevelAccessor)world, pos, info.state(), rayTraceResult.getLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)))) continue;
            MovementContext ctx = null;
            for (MutablePair<StructureTemplate.StructureBlockInfo, MovementContext> pair : contraption.getActors()) {
                if (!info.equals(pair.left)) continue;
                ctx = (MovementContext)pair.right;
                break;
            }
            if (ctx == null) continue;
            if (!(ctx.temporaryData instanceof ContraptionControlsMovement.ElevatorFloorSelection)) {
                ctx.temporaryData = new ContraptionControlsMovement.ElevatorFloorSelection();
            }
            ContraptionControlsMovement.ElevatorFloorSelection efs = (ContraptionControlsMovement.ElevatorFloorSelection)ctx.temporaryData;
            int prev = efs.currentIndex;
            efs.currentIndex = efs.currentIndex + (int)(delta > 0.0 ? Math.ceil(delta) : Math.floor(delta));
            ContraptionControlsMovement.tickFloorSelection(efs, ec);
            if (prev != efs.currentIndex && !ec.namesList.isEmpty()) {
                float pitch = (float)efs.currentIndex / (float)ec.namesList.size();
                pitch = Mth.lerp((float)pitch, (float)1.0f, (float)1.5f);
                AllSoundEvents.SCROLL_VALUE.play((Level)world, (Player)player, (Vec3i)BlockPos.containing((Position)contraptionEntity.toGlobalVector(rayTraceResult.getLocation(), 1.0f)), 1.0f, pitch);
            }
            return true;
        }
        return false;
    }

    private static class ElevatorControlsSlot
    extends ControlsSlot {
        private ElevatorControlsSlot() {
        }

        @Override
        public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
            Vec3 offset = this.getLocalOffset(state);
            if (offset == null) {
                return false;
            }
            return localHit.distanceTo(offset) < (double)this.scale * 0.85;
        }
    }
}

