/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.pulley.AbstractPulleyRenderer;
import com.zurrtum.create.client.content.contraptions.pulley.PulleyRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ElevatorPulleyRenderer
extends KineticBlockEntityRenderer<ElevatorPulleyBlockEntity, ElevatorPulleyRenderState> {
    public ElevatorPulleyRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public ElevatorPulleyRenderState createRenderState() {
        return new ElevatorPulleyRenderState();
    }

    @Override
    public void extractRenderState(ElevatorPulleyBlockEntity be, ElevatorPulleyRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        Level world = be.getLevel();
        BlockState blockState = be.getBlockState();
        float offset = PulleyRenderer.getBlockEntityOffset(tickProgress, be);
        boolean running = PulleyRenderer.isPulleyRunning(be);
        state.yRot = (float)Math.PI / 180 * (180.0f + AngleHelper.horizontalAngle((Direction)blockState.getValue((Property)ElevatorPulleyBlock.HORIZONTAL_FACING)));
        if (running || offset == 0.0f) {
            state.magnet = CachedBuffers.partial(AllPartialModels.ELEVATOR_MAGNET, blockState);
            state.magnetOffset = -offset;
            state.magnetLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)offset));
        }
        state.rotatedCoil = this.getRotatedCoil(be);
        if (offset == 0.0f) {
            return;
        }
        state.coilShift = AllSpriteShifts.ELEVATOR_COIL;
        state.coilScroll = AbstractPulleyRenderer.getCoilVScroll(state.coilShift, offset, 2.0f);
        float f = offset % 1.0f;
        if (f < 0.25f || f > 0.75f) {
            state.halfRope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT_HALF, blockState);
            ElevatorPulleyRenderer.updateHalfShift(state, offset);
            float down = f > 0.75f ? f - 1.0f : f;
            state.halfRopeOffset = -down;
            state.halfRopeLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)down));
        }
        if (!running) {
            return;
        }
        if (state.halfRope == null) {
            ElevatorPulleyRenderer.updateHalfShift(state, offset);
        }
        state.rope = CachedBuffers.partial(AllPartialModels.ELEVATOR_BELT, blockState);
        int size = (int)Math.ceil(offset - 0.25f);
        float[] offsets = new float[size];
        int[] lights = new int[size];
        for (int i = 0; i < size; ++i) {
            float down = offset - (float)i;
            int light = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.below((int)down));
            offsets[i] = -down;
            lights[i] = light;
        }
        state.offsets = offsets;
        state.lights = lights;
    }

    @Override
    public void submit(ElevatorPulleyRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    private static void updateHalfShift(ElevatorPulleyRenderState state, float offset) {
        state.halfShift = AllSpriteShifts.ELEVATOR_BELT;
        double beltScroll = (-((double)offset + 0.5) - Math.floor(-((double)offset + 0.5))) / 2.0;
        TextureAtlasSprite target = state.halfShift.getTarget();
        float spriteSize = target.getV1() - target.getV0();
        state.halfScroll = (float)beltScroll * spriteSize;
    }

    @Override
    protected RenderType getRenderType(ElevatorPulleyBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    @Override
    protected BlockState getRenderedBlockState(ElevatorPulleyBlockEntity be) {
        return ElevatorPulleyRenderer.shaft(ElevatorPulleyRenderer.getRotationAxisOf(be));
    }

    protected SuperByteBuffer getRotatedCoil(KineticBlockEntity be) {
        BlockState blockState = be.getBlockState();
        return CachedBuffers.partialFacing(AllPartialModels.ELEVATOR_COIL, blockState, (Direction)blockState.getValue((Property)ElevatorPulleyBlock.HORIZONTAL_FACING));
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public static class ElevatorPulleyRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public float yRot;
        public SuperByteBuffer magnet;
        public float magnetOffset;
        public int magnetLight;
        public SuperByteBuffer rotatedCoil;
        public SpriteShiftEntry coilShift;
        public float coilScroll;
        public SuperByteBuffer halfRope;
        public SpriteShiftEntry halfShift;
        public float halfScroll;
        public float halfRopeOffset;
        public int halfRopeLight;
        public SuperByteBuffer rope;
        public float[] offsets;
        public int[] lights;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            if (this.magnet != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.magnet.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.magnetOffset, 0.0f)).light(this.magnetLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.coilScroll != 0.0f) {
                this.rotatedCoil.shiftUVScrolling(this.coilShift, this.coilScroll);
            }
            this.rotatedCoil.light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (this.halfRope != null) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.halfRope.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.halfRopeOffset, 0.0f)).shiftUVScrolling(this.halfShift, this.halfScroll).light(this.halfRopeLight).renderInto(matricesEntry, vertexConsumer);
            }
            if (this.rope != null) {
                int size = this.offsets.length;
                for (int i = 0; i < size; ++i) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rope.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.offsets[i], 0.0f)).shiftUVScrolling(this.halfShift, this.halfScroll).light(this.lights[i]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}

