/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.elevator;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.content.contraptions.pulley.PulleyRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.content.processing.burner.ScrollInstance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.SectionTrackedVisual;
import com.zurrtum.create.client.flywheel.api.visual.ShaderLightVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.util.InstanceRecycler;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.client.foundation.render.SpecialModels;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlock;
import com.zurrtum.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ElevatorPulleyVisual
extends ShaftVisual<ElevatorPulleyBlockEntity>
implements SimpleDynamicVisual,
ShaderLightVisual {
    private final InstanceRecycler<ScrollInstance> belt;
    private final ScrollInstance halfBelt;
    private final ScrollInstance coil;
    private final TransformedInstance magnet;
    private final Matrix4fc cachedMagnetTransform;
    private float lastOffset = Float.NaN;
    private final long topSection;
    private long lastBottomSection;

    public ElevatorPulleyVisual(VisualizationContext context, ElevatorPulleyBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        float blockStateAngle = AngleHelper.horizontalAngle((Direction)this.blockState.getValue((Property)ElevatorPulleyBlock.HORIZONTAL_FACING));
        Quaternionf rotation = new Quaternionf().rotationY((float)Math.PI / 180 * blockStateAngle);
        this.topSection = SectionPos.of((BlockPos)this.pos).asLong();
        this.belt = new InstanceRecycler<ScrollInstance>(() -> ElevatorPulleyVisual.lambda$new$0(context, (Quaternionfc)rotation));
        this.halfBelt = context.instancerProvider().instancer(AllInstanceTypes.SCROLLING, SpecialModels.flatLit(AllPartialModels.ELEVATOR_BELT_HALF)).createInstance().rotation((Quaternionfc)rotation).setSpriteShift(AllSpriteShifts.ELEVATOR_BELT);
        this.coil = context.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial(AllPartialModels.ELEVATOR_COIL)).createInstance().position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)rotation).setSpriteShift(AllSpriteShifts.ELEVATOR_COIL);
        this.coil.setChanged();
        this.magnet = context.instancerProvider().instancer(InstanceTypes.TRANSFORMED, SpecialModels.flatLit(AllPartialModels.ELEVATOR_MAGNET)).createInstance();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.magnet.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(blockStateAngle)).uncenter();
        this.cachedMagnetTransform = new Matrix4f((Matrix4fc)this.magnet.pose);
        this.animate(PulleyRenderer.getBlockEntityOffset(partialTick, blockEntity));
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.coil);
        this.relight(this.magnet);
    }

    @Override
    public void setSectionCollector(SectionTrackedVisual.SectionCollector sectionCollector) {
        super.setSectionCollector(sectionCollector);
        sectionCollector.sections(this.getLightSections(this.lastOffset));
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(PulleyRenderer.getBlockEntityOffset(ctx.partialTick(), (PulleyBlockEntity)this.blockEntity));
    }

    @Override
    protected void _delete() {
        super._delete();
        this.belt.delete();
        this.halfBelt.delete();
        this.coil.delete();
        this.magnet.delete();
    }

    private void animate(float offset) {
        if (offset == this.lastOffset) {
            return;
        }
        this.lastOffset = offset;
        this.maybeUpdateSections(offset);
        this.animateCoil(offset);
        this.animateHalfBelt(offset);
        this.animateBelt(offset);
        this.animateMagnet(offset);
    }

    private void maybeUpdateSections(float offset) {
        if (this.lightSections == null) {
            return;
        }
        if (this.lastBottomSection == SectionPos.offset((long)this.topSection, (int)0, (int)(-ElevatorPulleyVisual.offset2SectionCount(offset)), (int)0)) {
            return;
        }
        this.lightSections.sections(this.getLightSections(offset));
    }

    private void animateMagnet(float offset) {
        ((TransformedInstance)this.magnet.setTransform(this.cachedMagnetTransform).translateY(-offset)).setChanged();
    }

    private void animateBelt(float offset) {
        this.belt.resetCount();
        int i = 0;
        while ((float)i < offset - 0.25f) {
            ScrollInstance segment = this.belt.get().position((Vec3i)this.getVisualPosition()).shift(0.0f, -(offset - (float)i), 0.0f);
            segment.offsetV = offset;
            segment.setChanged();
            ++i;
        }
        this.belt.discardExtra();
    }

    private void animateHalfBelt(float offset) {
        float f = offset % 1.0f;
        if (f < 0.25f || f > 0.75f) {
            this.halfBelt.setVisible(true);
            this.halfBelt.position((Vec3i)this.getVisualPosition()).shift(0.0f, -(f > 0.75f ? f - 1.0f : f), 0.0f);
            this.halfBelt.offsetV = offset;
            this.halfBelt.setChanged();
        } else {
            this.halfBelt.setVisible(false);
        }
    }

    private void animateCoil(float offset) {
        this.coil.offsetV = -offset * 2.0f;
        this.coil.setChanged();
    }

    private LongSet getLightSections(float offset) {
        LongArraySet out = new LongArraySet();
        int sectionCount = ElevatorPulleyVisual.offset2SectionCount(offset);
        for (int i = 0; i < sectionCount; ++i) {
            out.add(SectionPos.offset((long)this.topSection, (int)0, (int)(-i), (int)0));
        }
        this.lastBottomSection = SectionPos.offset((long)this.topSection, (int)0, (int)(-sectionCount), (int)0);
        return out;
    }

    private static int offset2SectionCount(float offset) {
        return (int)Math.ceil((offset + 1.0f) / 16.0f);
    }

    private static /* synthetic */ ScrollInstance lambda$new$0(VisualizationContext context, Quaternionfc rotation) {
        return context.instancerProvider().instancer(AllInstanceTypes.SCROLLING, SpecialModels.flatLit(AllPartialModels.ELEVATOR_BELT)).createInstance().rotation(rotation).setSpriteShift(AllSpriteShifts.ELEVATOR_BELT);
    }
}

