/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.gantry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlock;
import com.zurrtum.create.content.contraptions.gantry.GantryCarriageBlockEntity;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GantryCarriageRenderer
extends KineticBlockEntityRenderer<GantryCarriageBlockEntity, GantryCarriageRenderState> {
    public GantryCarriageRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public GantryCarriageRenderState createRenderState() {
        return new GantryCarriageRenderState();
    }

    @Override
    public void extractRenderState(GantryCarriageBlockEntity be, GantryCarriageRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            return;
        }
        BlockState blockState = be.getBlockState();
        Direction facing = (Direction)blockState.getValue((Property)GantryCarriageBlock.FACING);
        Boolean alongFirst = (Boolean)blockState.getValue((Property)GantryCarriageBlock.AXIS_ALONG_FIRST_COORDINATE);
        Direction.Axis rotationAxis = state.axis;
        BlockPos visualPos = facing.getAxisDirection() == Direction.AxisDirection.POSITIVE ? be.getBlockPos() : be.getBlockPos().relative(facing.getOpposite());
        float angleForBE = GantryCarriageRenderer.getAngleForBE(be, visualPos, rotationAxis);
        Direction.Axis gantryAxis = Direction.Axis.X;
        for (Direction.Axis axis : Iterate.axes) {
            if (axis == rotationAxis || axis == facing.getAxis()) continue;
            gantryAxis = axis;
        }
        if (gantryAxis == Direction.Axis.X && facing == Direction.UP) {
            angleForBE *= -1.0f;
        }
        if (gantryAxis == Direction.Axis.Y && (facing == Direction.NORTH || facing == Direction.EAST)) {
            angleForBE *= -1.0f;
        }
        state.cogs = CachedBuffers.partial(AllPartialModels.GANTRY_COGS, blockState);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 0 : (facing == Direction.DOWN ? 180 : 90));
        state.yRot2 = (float)Math.PI / 180 * (float)(alongFirst ^ facing.getAxis() == Direction.Axis.X ? 0 : 90);
        state.xRot2 = (float)Math.PI / 180 * -angleForBE;
    }

    @Override
    protected RenderType getRenderType(GantryCarriageBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    public static float getAngleForBE(KineticBlockEntity be, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float offset = GantryCarriageRenderer.getRotationOffsetForPosition(be, pos, axis);
        return (time * be.getSpeed() * 3.0f / 20.0f + offset) % 360.0f;
    }

    @Override
    protected BlockState getRenderedBlockState(GantryCarriageBlockEntity be) {
        return GantryCarriageRenderer.shaft(GantryCarriageRenderer.getRotationAxisOf(be));
    }

    public static class GantryCarriageRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer cogs;
        public float yRot;
        public float xRot;
        public float yRot2;
        public float xRot2;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cogs.center()).rotateY(this.yRot)).rotateX(this.xRot)).rotateY(this.yRot2);
            if (this.xRot2 != 0.0f) {
                ((SuperByteBuffer)((SuperByteBuffer)this.cogs.translate(0.0f, -0.5625f, 0.0f)).rotateX(this.xRot2)).translate(0.0f, 0.5625f, 0.0f);
            }
            ((SuperByteBuffer)this.cogs.uncenter()).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

