/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.minecart;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.infrastructure.packet.c2s.CouplingCreationPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CouplingHandlerClient {
    static AbstractMinecart selectedCart;
    static RandomSource r;

    public static void tick(Minecraft mc) {
        if (selectedCart == null) {
            return;
        }
        CouplingHandlerClient.spawnSelectionParticles(selectedCart.getBoundingBox(), false);
        LocalPlayer player = mc.player;
        ItemStack heldItemMainhand = player.getMainHandItem();
        ItemStack heldItemOffhand = player.getOffhandItem();
        if (heldItemMainhand.is((Item)AllItems.MINECART_COUPLING) || heldItemOffhand.is((Item)AllItems.MINECART_COUPLING)) {
            return;
        }
        selectedCart = null;
    }

    public static void onCartClicked(LocalPlayer player, AbstractMinecart entity) {
        if (Minecraft.getInstance().player != player) {
            return;
        }
        if (selectedCart == null || selectedCart == entity) {
            selectedCart = entity;
            CouplingHandlerClient.spawnSelectionParticles(selectedCart.getBoundingBox(), true);
            return;
        }
        CouplingHandlerClient.spawnSelectionParticles(entity.getBoundingBox(), true);
        player.connection.send((Packet)new CouplingCreationPacket(selectedCart, entity));
        selectedCart = null;
    }

    private static void spawnSelectionParticles(AABB box, boolean highlight) {
        ClientLevel world = Minecraft.getInstance().level;
        Vec3 center = box.getCenter();
        int amount = highlight ? 100 : 2;
        SimpleParticleType particleData = highlight ? ParticleTypes.END_ROD : new DustParticleOptions(0xFFFFFF, 1.0f);
        for (int i = 0; i < amount; ++i) {
            Vec3 v = VecHelper.offsetRandomly(Vec3.ZERO, r, 1.0f);
            double yOffset = v.y;
            v = v.multiply(1.0, 0.0, 1.0).normalize().add(0.0, yOffset / 8.0, 0.0).add(center);
            world.addParticle((ParticleOptions)particleData, v.x, v.y, v.z, 0.0, 0.0, 0.0);
        }
    }

    static {
        r = RandomSource.create();
    }
}

