/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.render.ShadedBlockSbbBuilder;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.client.content.contraptions.render.ContraptionMatrices;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.render.BlockEntityRenderHelper;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import com.zurrtum.create.content.contraptions.Contraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ContraptionEntityRenderer<C extends AbstractContraptionEntity, S extends AbstractContraptionState>
extends EntityRenderer<C, S> {
    public static final SuperByteBufferCache.Compartment<Pair<Contraption, ChunkSectionLayer>> CONTRAPTION = new SuperByteBufferCache.Compartment();
    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);
    private final PoseStack matrixStack = new PoseStack();

    public ContraptionEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public static SuperByteBuffer getBuffer(Contraption contraption, ClientContraption clientContraption, VirtualRenderWorld renderWorld, ChunkSectionLayer renderType) {
        return SuperByteBufferCache.getInstance().get(CONTRAPTION, Pair.of((Object)contraption, (Object)renderType), () -> ContraptionEntityRenderer.buildStructureBuffer(clientContraption, renderWorld, renderType));
    }

    public ClientContraption getOrCreateClientContraptionLazy(Contraption contraption) {
        AtomicReference<?> clientContraption = contraption.clientContraption;
        ClientContraption out = (ClientContraption)clientContraption.getAcquire();
        if (out == null) {
            clientContraption.compareAndExchangeRelease(null, this.createClientContraption(contraption));
            out = (ClientContraption)clientContraption.getAcquire();
        }
        return out;
    }

    protected ClientContraption createClientContraption(Contraption contraption) {
        return new ClientContraption(contraption);
    }

    private static SuperByteBuffer buildStructureBuffer(ClientContraption clientContraption, VirtualRenderWorld renderWorld, ChunkSectionLayer layer) {
        BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
        ModelBlockRenderer renderer = dispatcher.getModelRenderer();
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        PoseStack poseStack = objects.poseStack;
        RandomSource random = objects.random;
        ClientContraption.RenderedBlocks blocks = clientContraption.getRenderedBlocks();
        ShadedBlockSbbBuilder sbbBuilder = objects.sbbBuilder;
        sbbBuilder.begin();
        ModelBlockRenderer.enableCaching();
        for (BlockPos pos : blocks.positions()) {
            BlockState state = blocks.lookup().apply(pos);
            if (state.getRenderShape() != RenderShape.MODEL) continue;
            BlockStateModel model = dispatcher.getBlockModel(state);
            long randomSeed = state.getSeed(pos);
            random.setSeed(randomSeed);
            if (ItemBlockRenderTypes.getChunkRenderType((BlockState)state) != layer) continue;
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            ObjectArrayList parts = new ObjectArrayList();
            BlockStateModel blockStateModel = WrapperBlockStateModel.unwrapCompat(model);
            if (blockStateModel instanceof WrapperBlockStateModel) {
                WrapperBlockStateModel wrapper = (WrapperBlockStateModel)blockStateModel;
                wrapper.addPartsWithInfo((BlockAndTintGetter)renderWorld, pos, state, random, (List<BlockModelPart>)parts);
            } else {
                model.collectParts(random, (List)parts);
            }
            renderer.tesselateBlock((BlockAndTintGetter)renderWorld, (List)parts, state, pos, poseStack, (VertexConsumer)sbbBuilder, true, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        ModelBlockRenderer.clearCache();
        return sbbBuilder.end();
    }

    public boolean shouldRender(C entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        if (((AbstractContraptionEntity)((Object)entity)).getContraption() == null) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isAliveOrStale()) {
            return false;
        }
        if (!((AbstractContraptionEntity)((Object)entity)).isReadyForRender()) {
            return false;
        }
        return super.shouldRender(entity, frustum, cameraX, cameraY, cameraZ);
    }

    public S createRenderState() {
        return (S)((Object)new AbstractContraptionState());
    }

    public void extractRenderState(C entity, S state, float tickProgress) {
        ClientContraption clientContraption;
        ((AbstractContraptionState)((Object)state)).entityType = entity.getType();
        Contraption contraption = ((AbstractContraptionEntity)((Object)entity)).getContraption();
        ClientContraption clientContraption2 = clientContraption = contraption != null ? this.getOrCreateClientContraptionLazy(contraption) : null;
        if (clientContraption == null) {
            return;
        }
        Camera camera = this.entityRenderDispatcher.camera;
        if (camera == null) {
            return;
        }
        ((AbstractContraptionState)((Object)state)).contraption = contraption;
        ((AbstractContraptionState)((Object)state)).x = Mth.lerp((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).xOld, (double)entity.getX());
        ((AbstractContraptionState)((Object)state)).y = Mth.lerp((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).yOld, (double)entity.getY());
        ((AbstractContraptionState)((Object)state)).z = Mth.lerp((double)tickProgress, (double)((AbstractContraptionEntity)((Object)entity)).zOld, (double)entity.getZ());
        Level world = entity.level();
        VirtualRenderWorld renderWorld = clientContraption.getRenderLevel();
        ContraptionMatrices matrices = clientContraption.getMatrices();
        this.matrixStack.pushPose();
        Vec3 cameraPos = camera.position();
        this.matrixStack.translate(((AbstractContraptionState)((Object)state)).x - cameraPos.x, ((AbstractContraptionState)((Object)state)).y - cameraPos.y, ((AbstractContraptionState)((Object)state)).z - cameraPos.z);
        matrices.setup(this, this.matrixStack, state);
        PoseStack projection = new PoseStack();
        projection.last().set(matrices.getModelViewProjection().last());
        Matrix4f lightMatrix4f = new Matrix4f((Matrix4fc)matrices.getLight());
        Matrix4f worldMatrix4f = new Matrix4f((Matrix4fc)matrices.getWorld());
        matrices.clear();
        this.matrixStack.popPose();
        boolean support = VisualizationManager.supportsVisualization((LevelAccessor)world);
        if (!support) {
            ((AbstractContraptionState)((Object)state)).block = ContraptionBlockRenderState.create(contraption, clientContraption, renderWorld, projection, world, worldMatrix4f);
        }
        BitSet adjustRenderedBlockEntities = clientContraption.getAndAdjustShouldRenderBlockEntities();
        clientContraption.scratchErroredBlockEntities.clear();
        ((AbstractContraptionState)((Object)state)).blockEntity = BlockEntityRenderHelper.getBlockEntitiesRenderState(support, clientContraption.renderedBlockEntityView, adjustRenderedBlockEntities, clientContraption.scratchErroredBlockEntities, renderWorld, world, projection, lightMatrix4f, contraption.entity.toLocalVector(cameraPos, tickProgress), tickProgress);
        clientContraption.shouldRenderBlockEntities.andNot(clientContraption.scratchErroredBlockEntities);
        ((AbstractContraptionState)((Object)state)).actor = ActorListRenderState.create(cameraPos, this.getFont(), world, renderWorld, contraption, worldMatrix4f, projection);
    }

    public void submit(S state, PoseStack poseStack, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        if (((AbstractContraptionState)((Object)state)).contraption == null) {
            return;
        }
        if (((AbstractContraptionState)((Object)state)).block != null) {
            ((AbstractContraptionState)((Object)state)).block.render(queue);
        }
        if (((AbstractContraptionState)((Object)state)).blockEntity != null) {
            ((AbstractContraptionState)((Object)state)).blockEntity.render(queue, cameraRenderState);
        }
        if (((AbstractContraptionState)((Object)state)).actor != null) {
            ((AbstractContraptionState)((Object)state)).actor.render(queue);
        }
    }

    public void transform(S state, PoseStack matrixStack) {
    }

    private static class ThreadLocalObjects {
        public final PoseStack poseStack = new PoseStack();
        public final RandomSource random = RandomSource.createNewThreadLocalInstance();
        public final ShadedBlockSbbBuilder sbbBuilder = ShadedBlockSbbBuilder.create();

        private ThreadLocalObjects() {
        }
    }

    public static class AbstractContraptionState
    extends EntityRenderState {
        public Contraption contraption;
        public ContraptionBlockRenderState block;
        public BlockEntityRenderHelper.BlockEntityListRenderState blockEntity;
        public ActorListRenderState actor;
    }

    public record ContraptionBlockRenderState(PoseStack matrices, List<ContraptionBlockLayer> layers) {
        @Nullable
        public static ContraptionBlockRenderState create(Contraption contraption, ClientContraption clientContraption, VirtualRenderWorld renderWorld, PoseStack matrices, Level world, Matrix4f lightTransform) {
            ArrayList<ContraptionBlockLayer> layers = new ArrayList<ContraptionBlockLayer>();
            for (ChunkSectionLayer blockLayer : ChunkSectionLayer.values()) {
                SuperByteBuffer buffer = ContraptionEntityRenderer.getBuffer(contraption, clientContraption, renderWorld, blockLayer);
                if (buffer.isEmpty()) continue;
                layers.add(new ContraptionBlockLayer(ContraptionBlockRenderState.getRenderLayer(blockLayer), buffer, world, lightTransform));
            }
            if (layers.isEmpty()) {
                return null;
            }
            return new ContraptionBlockRenderState(matrices, layers);
        }

        private static RenderType getRenderLayer(ChunkSectionLayer layer) {
            return switch (layer) {
                default -> throw new MatchException(null, null);
                case ChunkSectionLayer.SOLID -> RenderTypes.solidMovingBlock();
                case ChunkSectionLayer.CUTOUT -> RenderTypes.cutoutMovingBlock();
                case ChunkSectionLayer.TRANSLUCENT -> RenderTypes.translucentMovingBlock();
                case ChunkSectionLayer.TRIPWIRE -> RenderTypes.tripwireMovingBlock();
            };
        }

        public void render(SubmitNodeCollector queue) {
            for (ContraptionBlockLayer layer : this.layers) {
                queue.submitCustomGeometry(this.matrices, layer.renderLayer, (SubmitNodeCollector.CustomGeometryRenderer)layer);
            }
        }
    }

    public record ActorListRenderState(PoseStack matrices, List<MovementRenderState> actors) {
        @Nullable
        public static ActorListRenderState create(Vec3 camera, Font textRenderer, Level world, VirtualRenderWorld renderWorld, Contraption contraption, Matrix4f worldMatrix4f, PoseStack viewProjection) {
            ArrayList<MovementRenderState> actors = new ArrayList<MovementRenderState>();
            for (Pair pair : contraption.getActors()) {
                MovementRenderState renderState;
                MovementRenderBehaviour render;
                MovementBehaviour movementBehaviour;
                MovementContext context = (MovementContext)pair.getRight();
                if (context == null) continue;
                if (context.world == null) {
                    context.world = world;
                }
                if ((movementBehaviour = MovementBehaviour.REGISTRY.get((StateHolder<Block, ?>)context.state)) == null || (render = (MovementRenderBehaviour)movementBehaviour.getAttachRender()) == null || contraption.isHiddenInPortal(context.localPos) || (renderState = render.getRenderState(camera, textRenderer, context, renderWorld, worldMatrix4f)) == null) continue;
                actors.add(renderState);
            }
            if (actors.isEmpty()) {
                return null;
            }
            return new ActorListRenderState(viewProjection, actors);
        }

        public void render(SubmitNodeCollector queue) {
            for (MovementRenderState actor : this.actors) {
                this.matrices.pushPose();
                actor.transform(this.matrices);
                actor.render(this.matrices, queue);
                this.matrices.popPose();
            }
        }
    }

    public record ContraptionBlockLayer(RenderType renderLayer, SuperByteBuffer buffer, Level world, Matrix4f lightTransform) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.buffer.useLevelLight((BlockAndTintGetter)this.world, this.lightTransform).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

