/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.contraptions.wrench;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.RenderElement;
import com.zurrtum.create.client.catnip.gui.render.DirectionIndicatorRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderState;
import com.zurrtum.create.client.catnip.gui.render.EntityBlockRenderer;
import com.zurrtum.create.client.content.contraptions.wrench.NonVisualizationLevel;
import com.zurrtum.create.client.content.contraptions.wrench.RadialWrenchHandler;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.ponder.enums.PonderGuiTextures;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.HorizontalKineticBlock;
import com.zurrtum.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.zurrtum.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlock;
import com.zurrtum.create.content.redstone.DirectedDirectionalBlock;
import com.zurrtum.create.infrastructure.packet.c2s.RadialWrenchMenuSubmitPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class RadialWrenchMenu
extends AbstractSimiScreen {
    public static final Map<Property<?>, String> VALID_PROPERTIES = new HashMap();
    public static final Set<Identifier> BLOCK_BLACKLIST;
    private final BlockState state;
    private final BlockPos pos;
    private final BlockEntity blockEntity;
    private final Level level;
    private final NonVisualizationLevel nonVisualizationLevel;
    private final List<Map.Entry<Property<?>, String>> propertiesForState;
    private final int innerRadius = 50;
    private final int outerRadius = 110;
    private int selectedPropertyIndex = 0;
    private List<BlockState> allStates = List.of();
    private String propertyLabel = "";
    private int ticksOpen;
    private int selectedStateIndex = 0;
    private final RenderElement iconScroll = RenderElement.of(PonderGuiTextures.ICON_SCROLL);
    private final RenderElement iconUp = RenderElement.of(AllIcons.I_PRIORITY_HIGH);
    private final RenderElement iconDown = RenderElement.of(AllIcons.I_PRIORITY_LOW);

    public static void registerRotationProperty(Property<?> property, String label) {
        if (VALID_PROPERTIES.containsKey(property)) {
            return;
        }
        VALID_PROPERTIES.put(property, label);
    }

    public static void registerBlacklistedBlock(Identifier location) {
        if (BLOCK_BLACKLIST.contains(location)) {
            return;
        }
        BLOCK_BLACKLIST.add(location);
    }

    public static Optional<RadialWrenchMenu> tryCreateFor(BlockState state, BlockPos pos, Level level) {
        if (BLOCK_BLACKLIST.contains(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()))) {
            return Optional.empty();
        }
        List<Map.Entry<Property<?>, String>> propertiesForState = VALID_PROPERTIES.entrySet().stream().filter(entry -> state.hasProperty((Property)entry.getKey())).toList();
        if (propertiesForState.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new RadialWrenchMenu(state, pos, level, propertiesForState));
    }

    private RadialWrenchMenu(BlockState state, BlockPos pos, Level level, List<Map.Entry<Property<?>, String>> properties) {
        this.state = state;
        this.pos = pos;
        this.level = level;
        this.nonVisualizationLevel = new NonVisualizationLevel(level);
        this.blockEntity = level.getBlockEntity(pos);
        this.propertiesForState = properties;
        this.initForSelectedProperty();
    }

    private void initForSelectedProperty() {
        Map.Entry<Property<?>, String> entry = this.propertiesForState.get(this.selectedPropertyIndex);
        this.allStates = new ArrayList<BlockState>();
        this.cycleAllPropertyValues(this.state, entry.getKey(), this.allStates);
        this.propertyLabel = entry.getValue();
    }

    private void cycleAllPropertyValues(BlockState state, Property<?> property, List<BlockState> states) {
        Optional first = property.getPossibleValues().stream().findFirst();
        if (first.isEmpty()) {
            return;
        }
        int offset = 0;
        int safety = 100;
        while (safety-- > 0) {
            if (state.getValue(property).equals(first.get())) {
                offset = 99 - safety;
                break;
            }
            state = (BlockState)state.cycle(property);
        }
        safety = 100;
        while (safety-- > 0 && !states.contains(state)) {
            states.add(state);
            state = (BlockState)state.cycle(property);
        }
        this.selectedStateIndex = (offset = Mth.clamp((int)offset, (int)0, (int)(states.size() - 1))) == 0 ? 0 : states.size() - offset;
    }

    @Override
    public void tick() {
        ++this.ticksOpen;
        if (this.minecraft != null && !this.level.getBlockState(this.pos).is(this.state.getBlock())) {
            this.minecraft.setScreen(null);
        }
        super.tick();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.width / 2;
        int y = this.height / 2;
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        ms.translate((float)x, (float)y);
        int mouseOffsetX = mouseX - this.width / 2;
        int mouseOffsetY = mouseY - this.height / 2;
        if (Mth.length((float)mouseOffsetX, (float)mouseOffsetY) > 45.0f) {
            double theta = Mth.atan2((double)mouseOffsetX, (double)mouseOffsetY);
            float sectorSize = 360.0f / (float)this.allStates.size();
            this.selectedStateIndex = (int)Math.floor((-AngleHelper.deg(Mth.atan2((double)mouseOffsetX, (double)mouseOffsetY)) + 180.0f + sectorSize / 2.0f) % 360.0f / sectorSize);
            this.renderDirectionIndicator(graphics, theta);
        }
        this.renderRadialSectors(graphics);
        UIRenderHelper.streak(graphics, 0.0f, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));
        UIRenderHelper.streak(graphics, 180.0f, 0, 0, 32, 65, Color.BLACK.setAlpha(0.8f));
        if (this.selectedPropertyIndex > 0) {
            this.iconScroll.at(-14.0f, -46.0f).render(graphics);
            this.iconUp.at(-1.0f, -46.0f).render(graphics);
            graphics.drawCenteredString(this.font, this.propertiesForState.get(this.selectedPropertyIndex - 1).getValue(), 0, -30, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        if (this.selectedPropertyIndex < this.propertiesForState.size() - 1) {
            this.iconScroll.at(-14.0f, 30.0f).render(graphics);
            this.iconDown.at(-1.0f, 30.0f).render(graphics);
            graphics.drawCenteredString(this.font, this.propertiesForState.get(this.selectedPropertyIndex + 1).getValue(), 0, 22, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        }
        graphics.drawCenteredString(this.font, "Currently", 0, -13, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.drawCenteredString(this.font, "Changing:", 0, -3, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        graphics.drawCenteredString(this.font, this.propertyLabel, 0, 7, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        ms.popMatrix();
    }

    private void renderRadialSectors(GuiGraphics graphics) {
        int sectors = this.allStates.size();
        if (sectors < 2) {
            return;
        }
        Matrix3x2fStack poseStack = graphics.pose();
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        float sectorAngle = 360.0f / (float)sectors;
        int sectorWidth = 60;
        poseStack.pushMatrix();
        for (int i = 0; i < sectors; ++i) {
            Color innerColor = Color.WHITE.setAlpha(0.05f);
            Color outerColor = Color.WHITE.setAlpha(0.3f);
            BlockState blockState = this.allStates.get(i);
            Property<?> property = this.propertiesForState.get(this.selectedPropertyIndex).getKey();
            poseStack.pushMatrix();
            if (i == this.selectedStateIndex) {
                innerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.2f), 0.5f);
                outerColor.mixWith(new Color(0.8f, 0.8f, 0.2f, 0.6f), 0.5f);
                UIRenderHelper.drawRadialSector(graphics, 112.0f, 113.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, outerColor, outerColor);
            }
            UIRenderHelper.drawRadialSector(graphics, 50.0f, 110.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, innerColor, outerColor);
            Color c = innerColor.copy().setAlpha(0.5f);
            UIRenderHelper.drawRadialSector(graphics, 47.0f, 48.0f, -(sectorAngle / 2.0f + 90.0f), sectorAngle, c, c);
            poseStack.translate(0.0f, -((float)sectorWidth / 2.0f + 50.0f));
            poseStack.rotate((float)Math.PI / 180 * ((float)(-i) * sectorAngle));
            graphics.guiRenderState.submitPicturesInPictureState((PictureInPictureRenderState)EntityBlockRenderState.create(i, graphics, this.nonVisualizationLevel, this.pos, this.blockEntity, blockState, -21, -21, 1.5f, 17, player.getXRot(), player.getYRot() + 180.0f, 0.0f));
            if (i == this.selectedStateIndex) {
                graphics.drawCenteredString(this.font, blockState.getValue(property).toString(), 0, 15, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
            }
            poseStack.popMatrix();
            poseStack.pushMatrix();
            poseStack.rotate((float)Math.PI / 180 * sectorAngle / 2.0f);
            poseStack.translate(0.0f, -70.0f);
            UIRenderHelper.angledGradient(graphics, -90.0f, 0, 0, 0.5f, sectorWidth - 10, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            UIRenderHelper.angledGradient(graphics, 90.0f, 0, 0, 0.5f, 25.0f, Color.WHITE.setAlpha(0.5f), Color.WHITE.setAlpha(0.15f));
            poseStack.popMatrix();
            poseStack.rotate((float)Math.PI / 180 * sectorAngle);
        }
        poseStack.popMatrix();
    }

    private void renderDirectionIndicator(GuiGraphics graphics, double theta) {
        Matrix3x2fStack poseStack = graphics.pose();
        poseStack.pushMatrix();
        poseStack.rotate((float)(-theta));
        poseStack.translate(0.0f, 53.0f);
        graphics.guiRenderState.submitGuiElement((GuiElementRenderState)new DirectionIndicatorRenderState(new Matrix3x2f((Matrix3x2fc)poseStack), 0.8f, 0.8f, 0.8f));
        poseStack.popMatrix();
    }

    private void submitChange() {
        BlockState selectedState = this.allStates.get(this.selectedStateIndex);
        if (selectedState != this.state) {
            this.minecraft.player.connection.send((Packet)new RadialWrenchMenuSubmitPacket(this.pos, selectedState));
        }
        this.onClose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Color color = BACKGROUND_COLOR.scaleAlpha(Math.min(1.0f, ((float)this.ticksOpen + AnimationTickHolder.getPartialTicks()) / 20.0f));
        guiGraphics.fillGradient(0, 0, this.width, this.height, color.getRGB(), color.getRGB());
    }

    public boolean keyReleased(KeyEvent input) {
        if (AllKeys.ROTATE_MENU.matches(input)) {
            this.submitChange();
            return true;
        }
        return super.keyReleased(input);
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        int button = click.button();
        if (button == 0) {
            this.submitChange();
            return true;
        }
        if (button == 1) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.propertiesForState.size() < 2) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        int indexDelta = (int)Math.round(Math.signum(-scrollY));
        int newIndex = this.selectedPropertyIndex + indexDelta;
        if (newIndex < 0) {
            return false;
        }
        if (newIndex >= this.propertiesForState.size()) {
            return false;
        }
        this.selectedPropertyIndex = newIndex;
        this.initForSelectedProperty();
        return true;
    }

    public void removed() {
        RadialWrenchHandler.COOLDOWN = 2;
        int size = this.allStates.size();
        for (int i = 0; i < size; ++i) {
            EntityBlockRenderer.clear(i);
        }
        super.removed();
    }

    static {
        RadialWrenchMenu.registerRotationProperty(RotatedPillarKineticBlock.AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(DirectionalKineticBlock.FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(HorizontalAxisKineticBlock.HORIZONTAL_AXIS, "Axis");
        RadialWrenchMenu.registerRotationProperty(HorizontalKineticBlock.HORIZONTAL_FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(HopperBlock.FACING, "Facing");
        RadialWrenchMenu.registerRotationProperty(DirectedDirectionalBlock.TARGET, "Target");
        RadialWrenchMenu.registerRotationProperty(SequencedGearshiftBlock.VERTICAL, "Vertical");
        BLOCK_BLACKLIST = new HashSet<Identifier>();
        RadialWrenchMenu.registerBlacklistedBlock(BuiltInRegistries.BLOCK.getKey((Object)AllBlocks.LARGE_WATER_WHEEL));
        RadialWrenchMenu.registerBlacklistedBlock(BuiltInRegistries.BLOCK.getKey((Object)AllBlocks.WATER_WHEEL_STRUCTURAL));
    }
}

