/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.decoration.girder;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.decoration.girder.GirderWrenchBehavior;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GirderWrenchBehaviorHandler {
    public static void tick(Minecraft mc) {
        HitResult hitResult;
        if (mc.player == null || mc.level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        LocalPlayer player = mc.player;
        ItemStack heldItem = player.getMainHandItem();
        if (player.isShiftKeyDown()) {
            return;
        }
        if (!world.getBlockState(pos).is((Block)AllBlocks.METAL_GIRDER)) {
            return;
        }
        if (!heldItem.is((Item)AllItems.WRENCH)) {
            return;
        }
        Pair<Direction, GirderWrenchBehavior.Action> dirPair = GirderWrenchBehavior.getDirectionAndAction(result, (Level)world, pos);
        if (dirPair == null) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 edge = center.add(Vec3.atLowerCornerOf((Vec3i)dirPair.getFirst().getUnitVec3i()).scale(0.4));
        Direction.Axis[] axes = (Direction.Axis[])Arrays.stream(Iterate.axes).filter(axis -> axis != ((Direction)dirPair.getFirst()).getAxis()).toArray(Direction.Axis[]::new);
        double normalMultiplier = dirPair.getSecond() == GirderWrenchBehavior.Action.PAIR ? 4.0 : 1.0;
        Vec3 corner1 = edge.add(Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axes[0], (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getUnitVec3i()).scale(0.3)).add(Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axes[1], (Direction.AxisDirection)Direction.AxisDirection.POSITIVE).getUnitVec3i()).scale(0.3)).add(Vec3.atLowerCornerOf((Vec3i)dirPair.getFirst().getUnitVec3i()).scale(0.1 * normalMultiplier));
        normalMultiplier = dirPair.getSecond() == GirderWrenchBehavior.Action.HORIZONTAL ? 9.0 : 2.0;
        Vec3 corner2 = edge.add(Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axes[0], (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).getUnitVec3i()).scale(0.3)).add(Vec3.atLowerCornerOf((Vec3i)Direction.fromAxisAndDirection((Direction.Axis)axes[1], (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE).getUnitVec3i()).scale(0.3)).add(Vec3.atLowerCornerOf((Vec3i)dirPair.getFirst().getOpposite().getUnitVec3i()).scale(0.1 * normalMultiplier));
        Outliner.getInstance().showAABB("girderWrench", new AABB(corner1, corner2)).lineWidth(0.03125f).colored(new Color(127, 127, 127));
    }
}

