/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.decoration.placard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.decoration.placard.PlacardBlock;
import com.zurrtum.create.content.decoration.placard.PlacardBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PlacardRenderer
implements BlockEntityRenderer<PlacardBlockEntity, PlacardRenderState> {
    protected final ItemModelResolver itemModelManager;

    public PlacardRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public PlacardRenderState createRenderState() {
        return new PlacardRenderState();
    }

    public void extractRenderState(PlacardBlockEntity be, PlacardRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        ItemStack heldItem = be.getHeldItem();
        if (heldItem.isEmpty()) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Direction facing = (Direction)state.blockState.getValue((Property)PlacardBlock.FACING);
        AttachFace face = (AttachFace)state.blockState.getValue((Property)PlacardBlock.FACE);
        ItemStackRenderState item = state.item = new ItemStackRenderState();
        item.displayContext = ItemDisplayContext.FIXED;
        this.itemModelManager.appendItemLayers(item, heldItem, item.displayContext, be.getLevel(), null, 0);
        boolean isCeiling = face == AttachFace.CEILING;
        state.upAngle = (isCeiling ? (float)Math.PI : 0.0f) + AngleHelper.rad(180.0f + AngleHelper.horizontalAngle(facing));
        state.eastAngle = isCeiling ? -1.5707964f : (face == AttachFace.FLOOR ? 1.5707964f : 0.0f);
        state.scale = item.usesBlockLight() ? 0.5f : 0.375f;
    }

    public void submit(PlacardRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        matrices.translate(0.5f, 0.5f, 0.5f);
        matrices.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(state.upAngle, 0.0f, 1.0f, 0.0f));
        matrices.mulPose((Quaternionfc)new Quaternionf().setAngleAxis(state.eastAngle, 1.0f, 0.0f, 0.0f));
        matrices.translate(0.0f, 0.0f, 0.28125f);
        float scale = state.scale;
        matrices.scale(scale, scale, scale);
        state.item.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
    }

    public static class PlacardRenderState
    extends BlockEntityRenderState {
        public ItemStackRenderState item;
        public float upAngle;
        public float eastAngle;
        public float scale;
    }
}

