/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.decoration.steamWhistle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.WhistleAnimationBehaviour;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlock;
import com.zurrtum.create.content.decoration.steamWhistle.WhistleBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WhistleRenderer
implements BlockEntityRenderer<WhistleBlockEntity, WhistleRenderState> {
    public WhistleRenderer(BlockEntityRendererProvider.Context context) {
    }

    public WhistleRenderState createRenderState() {
        return new WhistleRenderState();
    }

    public void extractRenderState(WhistleBlockEntity be, WhistleRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.blockState = be.getBlockState();
        if (!(state.blockState.getBlock() instanceof WhistleBlock)) {
            return;
        }
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        Level world = be.getLevel();
        state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        state.breakProgress = crumblingOverlay;
        state.layer = RenderTypes.solidMovingBlock();
        Direction direction = (Direction)state.blockState.getValue(WhistleBlock.FACING);
        WhistleBlock.WhistleSize size = (WhistleBlock.WhistleSize)((Object)state.blockState.getValue(WhistleBlock.SIZE));
        PartialModel mouth = size == WhistleBlock.WhistleSize.LARGE ? AllPartialModels.WHISTLE_MOUTH_LARGE : (size == WhistleBlock.WhistleSize.MEDIUM ? AllPartialModels.WHISTLE_MOUTH_MEDIUM : AllPartialModels.WHISTLE_MOUTH_SMALL);
        WhistleAnimationBehaviour behaviour = (WhistleAnimationBehaviour)be.getBehaviour(AnimationBehaviour.TYPE);
        float offset = behaviour.animation.getValue(tickProgress);
        if (behaviour.animation.getChaseTarget() > 0.0f && behaviour.animation.getValue() > 0.5f) {
            float wiggleProgress = ((float)AnimationTickHolder.getTicks((LevelAccessor)world) + tickProgress) / 8.0f;
            offset = (float)((double)offset - Math.sin(wiggleProgress * ((float)Math.PI * 2) * (float)(4 - size.ordinal())) / 16.0);
        }
        state.model = CachedBuffers.partial(mouth, state.blockState);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(direction);
        state.offset = offset * 4.0f / 16.0f;
    }

    public void submit(WhistleRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class WhistleRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float yRot;
        public float offset;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, this.offset, 0.0f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

