/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.equipment.armor.BacktankRenderer;
import com.zurrtum.create.content.equipment.armor.BacktankBlock;
import com.zurrtum.create.content.equipment.armor.BacktankItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BacktankFeatureRenderer<S extends HumanoidRenderState, M extends HumanoidModel<? super S>>
extends RenderLayer<S, M> {
    public BacktankFeatureRenderer(RenderLayerParent<S, M> context) {
        super(context);
    }

    public void submit(PoseStack ms, SubmitNodeCollector queue, int light, S entityState, float limbAngle, float limbDistance) {
        Item item;
        if (((HumanoidRenderState)entityState).pose == Pose.SLEEPING || !((item = ((HumanoidRenderState)entityState).chestEquipment.getItem()) instanceof BacktankItem)) {
            return;
        }
        BacktankItem item2 = (BacktankItem)item;
        BacktankRenderState state = new BacktankRenderState();
        BlockState blockState = (BlockState)item2.getBlock().defaultBlockState().setValue((Property)BacktankBlock.HORIZONTAL_FACING, (Comparable)Direction.SOUTH);
        state.backtank = CachedBuffers.block(blockState);
        state.cogs = CachedBuffers.partial(BacktankRenderer.getCogsModel(blockState), blockState);
        state.nob = CachedBuffers.partial(BacktankRenderer.getShaftModel(blockState), blockState);
        state.light = light;
        state.yRot = (float)Math.PI;
        state.angle = AngleHelper.rad(2.0f * AnimationTickHolder.getRenderTime() % 360.0f);
        ms.pushPose();
        ((HumanoidModel)this.getParentModel()).body.translateAndRotate(ms);
        ms.translate(-0.5f, 0.625f, 1.0f);
        ms.scale(1.0f, -1.0f, -1.0f);
        queue.submitCustomGeometry(ms, Sheets.cutoutBlockSheet(), (SubmitNodeCollector.CustomGeometryRenderer)state);
        ms.popPose();
    }

    public static class BacktankRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public SuperByteBuffer backtank;
        public SuperByteBuffer cogs;
        public SuperByteBuffer nob;
        public int light;
        public float yRot;
        public float angle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.backtank.disableDiffuse().light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)this.nob.disableDiffuse().translate(0.0f, -0.1875f, 0.0f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.cogs.center()).rotateY(this.yRot)).uncenter()).translate(0.0f, 0.40625f, 0.6875f)).rotate(this.angle, Direction.EAST)).translate(0.0f, -0.40625f, -0.6875f);
            this.cogs.disableDiffuse().light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

