/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.bell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.bell.AbstractBellBlockEntity;
import com.zurrtum.create.content.equipment.bell.PeculiarBellBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BellRenderer<BE extends AbstractBellBlockEntity>
implements BlockEntityRenderer<BE, BellRenderState> {
    public BellRenderer(BlockEntityRendererProvider.Context context) {
    }

    public BellRenderState createRenderState() {
        return new BellRenderState();
    }

    public void extractRenderState(BE be, BellRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase(be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.model = CachedBuffers.partial(be instanceof PeculiarBellBlockEntity ? AllPartialModels.PECULIAR_BELL : AllPartialModels.HAUNTED_BELL, state.blockState);
        if (((AbstractBellBlockEntity)be).isRinging) {
            state.direction = ((AbstractBellBlockEntity)be).ringDirection.getCounterClockWise();
            state.angle = BellRenderer.getSwingAngle((float)((AbstractBellBlockEntity)be).ringingTicks + tickProgress);
        }
        Direction facing = (Direction)state.blockState.getValue((Property)BellBlock.FACING);
        BellAttachType attachment = (BellAttachType)state.blockState.getValue((Property)BellBlock.ATTACHMENT);
        float rY = AngleHelper.horizontalAngle(facing);
        if (attachment == BellAttachType.SINGLE_WALL || attachment == BellAttachType.DOUBLE_WALL) {
            rY += 90.0f;
        }
        state.upAngle = AngleHelper.rad(rY);
    }

    public void submit(BellRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static float getSwingAngle(float time) {
        float t = time / 1.5f;
        return 1.2f * Mth.sin((double)(t / (float)Math.PI)) / (2.5f + t / 3.0f);
    }

    public static class BellRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float upAngle;
        public Direction direction;
        public float angle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.direction != null) {
                this.model.rotateCentered(this.angle, this.direction);
            }
            this.model.rotateCentered(this.upAngle, Direction.UP);
            this.model.light(this.lightCoords);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

