/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.blueprint;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class BlueprintRenderer
extends EntityRenderer<BlueprintEntity, BlueprintState> {
    protected final ItemModelResolver itemModelManager;

    public BlueprintRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelManager = context.getItemModelResolver();
    }

    public BlueprintState createRenderState() {
        return new BlueprintState();
    }

    public void extractRenderState(BlueprintEntity entity, BlueprintState state, float tickProgress) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, tickProgress);
        float yaw = entity.getYRot(tickProgress);
        float pitch = entity.getXRot();
        int size = entity.size;
        state.layer = Sheets.solidBlockSheet();
        PartialModel partialModel = size == 3 ? AllPartialModels.CRAFTING_BLUEPRINT_3x3 : (size == 2 ? AllPartialModels.CRAFTING_BLUEPRINT_2x2 : AllPartialModels.CRAFTING_BLUEPRINT_1x1);
        state.model = CachedBuffers.partial(partialModel, Blocks.AIR.defaultBlockState());
        state.yRot = (float)Math.PI / 180 * -yaw;
        state.xRot = (float)Math.PI / 180 * (90.0f + pitch);
        Vec3 offset = new Vec3(-0.5, -0.03125, -0.5);
        if (size == 2) {
            offset = offset.add(0.5, 0.0, -0.5);
        }
        state.offset = offset;
        Level level = entity.level();
        int itemSize = size * size * 2;
        ItemStackRenderState[] items = new ItemStackRenderState[itemSize];
        boolean empty = true;
        for (int i = 0; i < itemSize; ++i) {
            Couple<ItemStack> displayItems = entity.getSection(i >> 1).getDisplayItems();
            ItemStack firstStack = (ItemStack)displayItems.getFirst();
            if (!firstStack.isEmpty()) {
                empty = false;
                items[i] = BlueprintRenderer.createItemRenderState(this.itemModelManager, firstStack, level);
            }
            ++i;
            ItemStack secondStack = (ItemStack)displayItems.getSecond();
            if (secondStack.isEmpty()) continue;
            empty = false;
            items[i] = BlueprintRenderer.createItemRenderState(this.itemModelManager, secondStack, level);
        }
        if (empty) {
            return;
        }
        state.items = items;
        state.size = size;
        int bl = state.lightCoords >> 4 & 0xF;
        int sl = state.lightCoords >> 20 & 0xF;
        float f = state.normalYRot = pitch != 0.0f ? 0.0f : state.yRot;
        if (pitch == -90.0f) {
            state.normalXRot = -0.7853982f;
        } else if (pitch == 90.0f || yaw % 180.0f != 0.0f) {
            state.normalXRot = -0.2617994f;
            bl = (int)((double)bl / 1.35);
            sl = (int)((double)sl / 1.35);
        } else {
            state.normalXRot = -0.2617994f;
        }
        state.itemXRot = (float)Math.PI / 180 * pitch;
        state.itemOffsetZ = 0.03225f;
        if (size == 3) {
            state.itemOffsetXY = -1;
        }
        state.itemLight = Mth.floor((double)((double)sl + 0.5)) << 20 | (Mth.floor((double)((double)bl + 0.5)) & 0xF) << 4;
    }

    private static ItemStackRenderState createItemRenderState(ItemModelResolver itemModelManager, ItemStack stack, Level world) {
        ItemStackRenderState state = new ItemStackRenderState();
        state.displayContext = ItemDisplayContext.GUI;
        itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
        return state;
    }

    public void submit(BlueprintState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        ItemStackRenderState[] items = state.items;
        if (items == null) {
            return;
        }
        matrices.pushPose();
        PoseStack.Pose entry = matrices.last();
        Matrix3f normal = entry.normal();
        if (state.normalYRot != 0.0f) {
            normal.rotate((Quaternionfc)Axis.YP.rotation(state.normalYRot));
        }
        normal.rotate((Quaternionfc)Axis.XP.rotation(state.normalXRot));
        Matrix4f pose = entry.pose();
        pose.rotate((Quaternionfc)Axis.YP.rotation(state.yRot));
        pose.rotate((Quaternionfc)Axis.XP.rotation(state.itemXRot));
        pose.translate((float)state.itemOffsetXY, (float)state.itemOffsetXY, state.itemOffsetZ);
        Matrix4f copy = new Matrix4f((Matrix4fc)pose);
        int light = state.itemLight;
        int i = 0;
        int size = items.length;
        int n = 0;
        int w = state.size - 1;
        while (i < size) {
            ItemStackRenderState firstState = items[i++];
            ItemStackRenderState secondState = items[i++];
            if (firstState != null || secondState != null) {
                pose.scale(0.5f, 0.5f, 9.765625E-4f);
                if (firstState != null) {
                    firstState.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
                }
                if (secondState != null) {
                    pose.translate(0.325f, -0.325f, 1.0f);
                    pose.scale(0.625f, 0.625f, 1.0f);
                    secondState.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
                }
            }
            if (n < w) {
                copy.translate(1.0f, 0.0f, 0.0f);
                ++n;
            } else {
                copy.translate((float)(-w), 1.0f, 0.0f);
                n = 0;
            }
            pose.set((Matrix4fc)copy);
        }
        matrices.popPose();
    }

    public static class BlueprintState
    extends EntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer model;
        public float yRot;
        public float xRot;
        public Vec3 offset;
        public ItemStackRenderState[] items;
        public int size;
        public float normalYRot;
        public float normalXRot;
        public float itemXRot;
        public int itemOffsetXY;
        public float itemOffsetZ;
        public int itemLight;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateY(this.yRot)).rotateX(this.xRot)).translate(this.offset)).disableDiffuse().light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

