/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.clipboard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.clipboard.ClipboardBlockEntity;
import com.zurrtum.create.content.equipment.clipboard.ClipboardCloneable;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.filtering.ServerFilteringBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClipboardValueSettingsClientHandler {
    public static boolean drawCustomBlockSelection(Minecraft mc, BlockPos pos, MultiBufferSource vertexConsumerProvider, Vec3 camPos, PoseStack ms) {
        VoxelShape shape;
        HitResult hitResult;
        LocalPlayer player = mc.player;
        if (player == null || player.isSpectator()) {
            return false;
        }
        if (!player.getMainHandItem().is((Item)AllItems.CLIPBOARD)) {
            return false;
        }
        ClientLevel world = mc.level;
        if (!world.getWorldBorder().isWithinBounds(pos)) {
            return false;
        }
        BlockState blockstate = world.getBlockState(pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return false;
        }
        SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
        if (!(smartBE instanceof ClipboardBlockEntity) && !(smartBE instanceof ClipboardCloneable) && (hitResult = mc.hitResult) instanceof BlockHitResult) {
            BlockHitResult target = (BlockHitResult)hitResult;
            RegistryAccess registryManager = world.registryAccess();
            Direction side = target.getDirection();
            if (Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE).noneMatch(type -> {
                ClipboardCloneable cc;
                Object patt0$temp = smartBE.getBehaviour(type);
                return patt0$temp instanceof ClipboardCloneable && (cc = (ClipboardCloneable)patt0$temp).canWrite((HolderLookup.Provider)registryManager, side);
            })) {
                return false;
            }
        }
        if ((shape = blockstate.getShape((BlockGetter)world, pos)).isEmpty()) {
            return false;
        }
        VertexConsumer vb = vertexConsumerProvider.getBuffer(RenderTypes.lines());
        ms.pushPose();
        ms.translate((double)pos.getX() - camPos.x, (double)pos.getY() - camPos.y, (double)pos.getZ() - camPos.z);
        TrackBlockOutline.renderShape(shape, ms, vb, true);
        ms.popPose();
        return true;
    }

    public static void clientTick(Minecraft mc) {
        boolean canPaste;
        ClipboardCloneable ccbe;
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult target = (BlockHitResult)hitResult;
        LocalPlayer player = mc.player;
        ItemStack stack = player.getMainHandItem();
        if (!stack.is((Item)AllItems.CLIPBOARD)) {
            return;
        }
        ClientLevel level = mc.level;
        BlockPos pos = target.getBlockPos();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return;
        }
        SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
        if (smartBE instanceof ClipboardBlockEntity) {
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(CreateLang.translateDirect("clipboard.actions", new Object[0]));
            tip.add(CreateLang.translateDirect("clipboard.copy_other_clipboard", Component.keybind((String)"key.use")));
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
            return;
        }
        Direction side = target.getDirection();
        boolean canCopy = Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE).anyMatch(type -> {
            ClipboardCloneable cc;
            Object patt0$temp = smartBE.getBehaviour(type);
            return patt0$temp instanceof ClipboardCloneable && (cc = (ClipboardCloneable)patt0$temp).canWrite((HolderLookup.Provider)level.registryAccess(), side);
        }) || smartBE instanceof ClipboardCloneable && (ccbe = (ClipboardCloneable)((Object)smartBE)).canWrite((HolderLookup.Provider)level.registryAccess(), side);
        ClipboardContent content = (ClipboardContent)stack.get(AllDataComponents.CLIPBOARD_CONTENT);
        if (content == null) {
            return;
        }
        CompoundTag tagElement = content.copiedValues().orElse(null);
        if (tagElement == null) {
            canPaste = false;
        } else {
            try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(smartBE.problemPath(), com.zurrtum.create.Create.LOGGER);){
                ClipboardCloneable ccbe2;
                ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)tagElement);
                canPaste = Stream.of(ServerScrollValueBehaviour.TYPE, ServerFilteringBehaviour.TYPE, ServerLinkBehaviour.TYPE).anyMatch(type -> {
                    ClipboardCloneable cc;
                    Object patt0$temp = smartBE.getBehaviour(type);
                    return patt0$temp instanceof ClipboardCloneable && view.child((cc = (ClipboardCloneable)patt0$temp).getClipboardKey()).map(v -> cc.readFromClipboard((ValueInput)v, (Player)player, side, true)).orElse(false) != false;
                }) || smartBE instanceof ClipboardCloneable && view.child((ccbe2 = (ClipboardCloneable)((Object)smartBE)).getClipboardKey()).map(v -> ccbe2.readFromClipboard((ValueInput)v, (Player)player, side, true)).orElse(false) != false;
            }
        }
        if (!canCopy && !canPaste) {
            return;
        }
        ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
        tip.add(CreateLang.translateDirect("clipboard.actions", new Object[0]));
        if (canCopy) {
            tip.add(CreateLang.translateDirect("clipboard.to_copy", Component.keybind((String)"key.use")));
        }
        if (canPaste) {
            tip.add(CreateLang.translateDirect("clipboard.to_paste", Component.keybind((String)"key.attack")));
        }
        Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
    }
}

