/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.goggles;

import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.equipment.goggles.IProxyHoveringInformation;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.api.goggles.IHaveCustomOverlayIcon;
import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.api.goggles.IHaveHoveringInformation;
import com.zurrtum.create.client.catnip.gui.element.BoxElement;
import com.zurrtum.create.client.catnip.outliner.Outline;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.contraptions.IDisplayAssemblyExceptions;
import com.zurrtum.create.client.content.trains.entity.TrainRelocatorClient;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip.TooltipBehaviour;
import com.zurrtum.create.client.foundation.gui.RemovedGuiUtils;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.config.AllConfigs;
import com.zurrtum.create.client.infrastructure.config.CClient;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock;
import com.zurrtum.create.content.contraptions.piston.PistonExtensionPoleBlock;
import com.zurrtum.create.content.equipment.goggles.GogglesItem;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix3x2fStack;

public class GoggleOverlayRenderer {
    private static final Map<Object, Outliner.OutlineEntry> outlines = Outliner.getInstance().getOutlines();
    public static int hoverTicks = 0;
    public static BlockPos lastHovered = null;

    public static void renderOverlay(Minecraft mc, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Color colorBorderBot;
        boolean exceptionAdded;
        HitResult objectMouseOver = mc.hitResult;
        if (!(objectMouseOver instanceof BlockHitResult)) {
            lastHovered = null;
            hoverTicks = 0;
            return;
        }
        BlockHitResult result = (BlockHitResult)objectMouseOver;
        for (Outliner.OutlineEntry entry : outlines.values()) {
            Outline outline;
            if (!entry.isAlive() || !((outline = entry.getOutline()) instanceof ValueBox) || ((ValueBox)outline).isPassive) continue;
            return;
        }
        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        int prevHoverTicks = hoverTicks++;
        lastHovered = pos;
        pos = GoggleOverlayRenderer.proxiedOverlayPosition((Level)world, pos);
        TooltipBehaviour<?> be = BlockEntityBehaviour.get((BlockGetter)world, pos, TooltipBehaviour.TYPE);
        boolean wearingGoggles = GogglesItem.isWearingGoggles((Player)mc.player);
        boolean isShifting = mc.player.isShiftKeyDown();
        boolean hasGoggleInformation = be instanceof IHaveGoggleInformation;
        boolean hasHoveringInformation = be instanceof IHaveHoveringInformation;
        boolean goggleAddedInformation = false;
        boolean hoverAddedInformation = false;
        ItemStack item = new ItemStack((ItemLike)AllItems.GOGGLES);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (be instanceof IHaveCustomOverlayIcon) {
            IHaveCustomOverlayIcon customOverlayIcon = (IHaveCustomOverlayIcon)((Object)be);
            item = customOverlayIcon.getIcon(isShifting);
        }
        if (hasGoggleInformation && wearingGoggles) {
            IHaveGoggleInformation gte = (IHaveGoggleInformation)((Object)be);
            goggleAddedInformation = gte.addToGoggleTooltip(tooltip, isShifting);
        }
        if (hasHoveringInformation) {
            if (!tooltip.isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
            }
            IHaveHoveringInformation hte = (IHaveHoveringInformation)((Object)be);
            hoverAddedInformation = hte.addToTooltip(tooltip, isShifting);
            if (goggleAddedInformation && !hoverAddedInformation) {
                tooltip.remove(tooltip.size() - 1);
            }
        }
        if (be instanceof IDisplayAssemblyExceptions && (exceptionAdded = ((IDisplayAssemblyExceptions)((Object)be)).addExceptionToTooltip(tooltip))) {
            hasHoveringInformation = true;
            hoverAddedInformation = true;
        }
        if (!hasHoveringInformation) {
            hasHoveringInformation = hoverAddedInformation = TrainRelocatorClient.addToTooltip(tooltip);
            if (hoverAddedInformation) {
                hoverTicks = prevHoverTicks + 1;
            }
        }
        if (hasGoggleInformation && !goggleAddedInformation && hasHoveringInformation && !hoverAddedInformation) {
            hoverTicks = 0;
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (wearingGoggles && state.is((Block)AllBlocks.PISTON_EXTENSION_POLE)) {
            Direction[] directions = Iterate.directionsInAxis(((Direction)state.getValue((Property)PistonExtensionPoleBlock.FACING)).getAxis());
            int poles = 1;
            boolean pistonFound = false;
            for (Direction dir : directions) {
                int attachedPoles = PistonExtensionPoleBlock.PlacementHelper.get().attachedPoles((Level)world, pos, dir);
                poles += attachedPoles;
                pistonFound |= world.getBlockState(pos.relative(dir, attachedPoles + 1)).getBlock() instanceof MechanicalPistonBlock;
            }
            if (!pistonFound) {
                hoverTicks = 0;
                return;
            }
            if (!tooltip.isEmpty()) {
                tooltip.add(CommonComponents.EMPTY);
            }
            CreateLang.translate("gui.goggles.pole_length", new Object[0]).text(" " + poles).forGoggles(tooltip);
        }
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.font.width(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2;
            tooltipHeight += (tooltip.size() - 1) * 10;
        }
        int n = guiGraphics.guiWidth();
        int height = guiGraphics.guiHeight();
        CClient cfg = AllConfigs.client();
        int posX = n / 2 + (Integer)cfg.overlayOffsetX.get();
        int posY = height / 2 + (Integer)cfg.overlayOffsetY.get();
        posX = Math.min(posX, n - tooltipTextWidth - 20);
        posY = Math.min(posY, height - tooltipHeight - 20);
        float fade = Mth.clamp((float)(((float)hoverTicks + deltaTracker.getGameTimeDeltaPartialTick(false)) / 24.0f), (float)0.0f, (float)1.0f);
        Boolean useCustom = (Boolean)cfg.overlayCustomColor.get();
        Color colorBackground = useCustom != false ? new Color((Integer)cfg.overlayBackgroundColor.get()) : BoxElement.COLOR_VANILLA_BACKGROUND.scaleAlpha(0.75f);
        Color colorBorderTop = useCustom != false ? new Color((Integer)cfg.overlayBorderColorTop.get()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getFirst()).copy();
        Color color = colorBorderBot = useCustom != false ? new Color((Integer)cfg.overlayBorderColorBot.get()) : ((Color)BoxElement.COLOR_VANILLA_BORDER.getSecond()).copy();
        if (fade < 1.0f) {
            poseStack.translate((float)(Math.pow(1.0f - fade, 3.0) * (double)Math.signum((float)((Integer)cfg.overlayOffsetX.get()).intValue() + 0.5f) * 8.0), 0.0f);
            colorBackground.scaleAlpha(fade);
            colorBorderTop.scaleAlpha(fade);
            colorBorderBot.scaleAlpha(fade);
        }
        MouseHandler mouseHandler = mc.mouseHandler;
        Window window = mc.getWindow();
        double guiScale = window.getGuiScale();
        double cursorX = mouseHandler.xpos();
        double cursorY = mouseHandler.ypos();
        mouseHandler.xpos = (double)Math.round(cursorX / guiScale) * guiScale;
        mouseHandler.ypos = (double)Math.round(cursorY / guiScale) * guiScale;
        RemovedGuiUtils.drawHoveringText(guiGraphics, tooltip, posX, posY, n, height, -1, colorBackground.getRGB(), colorBorderTop.getRGB(), colorBorderBot.getRGB(), mc.font);
        guiGraphics.renderItem(item, posX + 10, posY - 16);
        mouseHandler.xpos = cursorX;
        mouseHandler.ypos = cursorY;
        poseStack.popMatrix();
    }

    public static BlockPos proxiedOverlayPosition(Level level, BlockPos pos) {
        BlockState targetedState = level.getBlockState(pos);
        Block block = targetedState.getBlock();
        if (block instanceof IProxyHoveringInformation) {
            IProxyHoveringInformation proxy = (IProxyHoveringInformation)block;
            return proxy.getInformationSource(level, pos, targetedState);
        }
        return pos;
    }
}

