/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.symmetryWand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SymmetryHandlerClient {
    private static int tickCounter = 0;

    public static void onRenderWorld(Minecraft mc, PoseStack ms, MultiBufferSource buffer, Vec3 cameraPos) {
        LocalPlayer player = mc.player;
        Inventory inventory = player.getInventory();
        int size = Inventory.getSelectionSize();
        for (int i = 0; i < size; ++i) {
            SymmetryMirror mirror;
            ItemStack stackInSlot = inventory.getItem(i);
            if (!stackInSlot.is((Item)AllItems.WAND_OF_SYMMETRY) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
            BlockPos pos = BlockPos.containing((Position)mirror.getPosition());
            double speed = 0.0625;
            float yShift = Mth.sin((double)((float)((double)AnimationTickHolder.getRenderTime() * speed))) / 5.0f;
            ms.pushPose();
            ms.translate((double)pos.getX() - cameraPos.x(), (double)pos.getY() - cameraPos.y(), (double)pos.getZ() - cameraPos.z());
            ms.translate(0.0f, yShift + 0.2f, 0.0f);
            SymmetryHandlerClient.applyModelTransform(mirror, ms);
            SimpleModelWrapper model = SymmetryHandlerClient.getModel(mirror).get();
            VertexConsumer builder = buffer.getBuffer(RenderTypes.solidMovingBlock());
            mc.getBlockRenderer().getModelRenderer().tesselateBlock((BlockAndTintGetter)mc.level, List.of(model), Blocks.AIR.defaultBlockState(), pos, ms, builder, true, OverlayTexture.NO_OVERLAY);
            ms.popPose();
        }
    }

    @Nullable
    public static PartialModel getModel(SymmetryMirror mirror) {
        SymmetryMirror symmetryMirror = mirror;
        Objects.requireNonNull(symmetryMirror);
        SymmetryMirror symmetryMirror2 = symmetryMirror;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlaneMirror.class, CrossPlaneMirror.class, TriplePlaneMirror.class}, (Object)symmetryMirror2, n)) {
            case 0 -> {
                PlaneMirror planeMirror = (PlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_PLANE;
            }
            case 1 -> {
                CrossPlaneMirror crossPlaneMirror = (CrossPlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_CROSSPLANE;
            }
            case 2 -> {
                TriplePlaneMirror triplePlaneMirror = (TriplePlaneMirror)symmetryMirror2;
                yield AllPartialModels.SYMMETRY_TRIPLEPLANE;
            }
            default -> throw new IllegalArgumentException("Unknown mirror type: " + mirror.getClass().getName());
        };
    }

    public static void applyModelTransform(SymmetryMirror mirror, PoseStack ms) {
        if (mirror instanceof PlaneMirror) {
            if (mirror.orientation != PlaneMirror.Align.XY) {
                ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).center()).rotateYDegrees(90.0f)).uncenter();
            }
        } else if (mirror instanceof CrossPlaneMirror && mirror.orientation != CrossPlaneMirror.Align.Y) {
            ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).center()).rotateYDegrees(45.0f)).uncenter();
        }
    }

    public static void onClientTick(Minecraft mc) {
        ClientLevel world = mc.level;
        if (world == null) {
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        LocalPlayer player = mc.player;
        if (++tickCounter % 10 == 0) {
            Inventory inventory = player.getInventory();
            int size = Inventory.getSelectionSize();
            for (int i = 0; i < size; ++i) {
                SymmetryMirror mirror;
                ItemStack stackInSlot = inventory.getItem(i);
                if (!stackInSlot.is((Item)AllItems.WAND_OF_SYMMETRY) || !SymmetryWandItem.isEnabled(stackInSlot) || (mirror = SymmetryWandItem.getMirror(stackInSlot)) instanceof EmptyMirror) continue;
                RandomSource random = mc.level.random;
                double offsetX = (random.nextDouble() - 0.5) * 0.3;
                double offsetZ = (random.nextDouble() - 0.5) * 0.3;
                Vec3 pos = mirror.getPosition().add(0.5 + offsetX, 0.25, 0.5 + offsetZ);
                Vec3 speed = new Vec3(0.0, random.nextDouble() * 1.0 / 8.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.END_ROD, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
            }
        }
    }

    public static void drawEffect(Minecraft client, BlockPos from, BlockPos to) {
        Vec3 pos;
        RandomSource random = client.level.random;
        double density = 0.8f;
        Vec3 start = Vec3.atLowerCornerOf((Vec3i)from).add(0.5, 0.5, 0.5);
        Vec3 end = Vec3.atLowerCornerOf((Vec3i)to).add(0.5, 0.5, 0.5);
        Vec3 diff = end.subtract(start);
        Vec3 step = diff.normalize().scale(density);
        int steps = (int)(diff.length() / step.length());
        ClientLevel world = client.level;
        for (int i = 3; i < steps - 1; ++i) {
            pos = start.add(step.scale((double)i));
            Vec3 speed = new Vec3(0.0, random.nextDouble() * -40.0, 0.0);
            world.addParticle((ParticleOptions)new DustParticleOptions(65793, 1.0f), pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        }
        Vec3 speed = new Vec3(0.0, random.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.add(step.scale(2.0));
        world.addParticle((ParticleOptions)ParticleTypes.END_ROD, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
        speed = new Vec3(0.0, random.nextDouble() * 1.0 / 32.0, 0.0);
        pos = start.add(step.scale((double)steps));
        world.addParticle((ParticleOptions)ParticleTypes.END_ROD, pos.x, pos.y, pos.z, speed.x, speed.y, speed.z);
    }
}

