/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.symmetryWand;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryHandlerClient;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.symmetryWand.SymmetryWandItem;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.CrossPlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.EmptyMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.PlaneMirror;
import com.zurrtum.create.content.equipment.symmetryWand.mirror.TriplePlaneMirror;
import com.zurrtum.create.infrastructure.component.SymmetryMirror;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureSymmetryWandPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SymmetryWandScreen
extends AbstractSimiScreen {
    private final AllGuiTextures background = AllGuiTextures.WAND_OF_SYMMETRY;
    private ScrollInput areaType;
    private Label labelType;
    private ScrollInput areaAlign;
    private Label labelAlign;
    private IconButton confirmButton;
    private ElementWidget renderedItem;
    private ElementWidget renderedBlock;
    private final Component mirrorType = CreateLang.translateDirect("gui.symmetryWand.mirrorType", new Object[0]);
    private final Component orientation = CreateLang.translateDirect("gui.symmetryWand.orientation", new Object[0]);
    private SymmetryMirror currentElement;
    private final ItemStack wand;
    private final InteractionHand hand;

    public SymmetryWandScreen(ItemStack wand, InteractionHand hand) {
        this.currentElement = SymmetryWandItem.getMirror(wand);
        if (this.currentElement instanceof EmptyMirror) {
            this.currentElement = new PlaneMirror(Vec3.ZERO);
        }
        this.hand = hand;
        this.wand = wand;
    }

    public static List<Component> getMirrors() {
        return ImmutableList.of((Object)CreateLang.translateDirect("symmetry.mirror.plane", new Object[0]), (Object)CreateLang.translateDirect("symmetry.mirror.doublePlane", new Object[0]), (Object)CreateLang.translateDirect("symmetry.mirror.triplePlane", new Object[0]));
    }

    public static List<Component> getAlignToolTips(SymmetryMirror element) {
        SymmetryMirror symmetryMirror = element;
        Objects.requireNonNull(symmetryMirror);
        SymmetryMirror symmetryMirror2 = symmetryMirror;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlaneMirror.class, CrossPlaneMirror.class, TriplePlaneMirror.class}, (Object)symmetryMirror2, n)) {
            case 0 -> {
                PlaneMirror planeMirror = (PlaneMirror)symmetryMirror2;
                yield ImmutableList.of((Object)CreateLang.translateDirect("orientation.alongZ", new Object[0]), (Object)CreateLang.translateDirect("orientation.alongX", new Object[0]));
            }
            case 1 -> {
                CrossPlaneMirror crossPlaneMirror = (CrossPlaneMirror)symmetryMirror2;
                yield ImmutableList.of((Object)CreateLang.translateDirect("orientation.orthogonal", new Object[0]), (Object)CreateLang.translateDirect("orientation.diagonal", new Object[0]));
            }
            case 2 -> {
                TriplePlaneMirror triplePlaneMirror = (TriplePlaneMirror)symmetryMirror2;
                yield ImmutableList.of((Object)CreateLang.translateDirect("orientation.horizontal", new Object[0]));
            }
            default -> ImmutableList.of();
        };
    }

    @Override
    public void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-20, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.labelType = new Label(x + 51, y + 28, CommonComponents.EMPTY).colored(-1).withShadow();
        this.labelAlign = new Label(x + 51, y + 50, CommonComponents.EMPTY).colored(-1).withShadow();
        int state = this.currentElement instanceof TriplePlaneMirror ? 2 : (this.currentElement instanceof CrossPlaneMirror ? 1 : 0);
        this.areaType = new SelectionScrollInput(x + 45, y + 21, 109, 18).forOptions(SymmetryWandScreen.getMirrors()).titled(this.mirrorType.plainCopy()).writingTo(this.labelType).setState(state);
        this.areaType.calling(position -> {
            switch (position) {
                case 0: {
                    this.currentElement = new PlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 1: {
                    this.currentElement = new CrossPlaneMirror(this.currentElement.getPosition());
                    break;
                }
                case 2: {
                    this.currentElement = new TriplePlaneMirror(this.currentElement.getPosition());
                    break;
                }
            }
            this.initAlign(this.currentElement, x, y);
            ((GuiGameElement.GuiPartialRenderBuilder)this.renderedBlock.getRenderElement()).partial(SymmetryHandlerClient.getModel(this.currentElement));
        });
        this.initAlign(this.currentElement, x, y);
        this.addRenderableWidget(this.labelAlign);
        this.addRenderableWidget(this.areaType);
        this.addRenderableWidget(this.labelType);
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.renderedItem = new ElementWidget(x + 140, y - 4).showingElement(GuiGameElement.of(this.wand).rotate(-70.0f, 20.0f, 20.0f).scale(4.0f).padding(100));
        this.addRenderableWidget(this.renderedItem);
        this.renderedBlock = new ElementWidget(x + 23, y + 24).showingElement(GuiGameElement.of(SymmetryHandlerClient.getModel(this.currentElement)).transform(this::transformBlock));
        this.addRenderableWidget(this.renderedBlock);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
        this.renderedBlock.getRenderElement().clear();
    }

    private void initAlign(SymmetryMirror element, int x, int y) {
        if (this.areaAlign != null) {
            this.removeWidget(this.areaAlign);
        }
        this.areaAlign = new SelectionScrollInput(x + 45, y + 43, 109, 18).forOptions(SymmetryWandScreen.getAlignToolTips(element)).titled(this.orientation.plainCopy()).writingTo(this.labelAlign).setState(element.getOrientationIndex()).calling(index -> {
            element.setOrientation((int)index);
            ((GuiGameElement.GuiPartialRenderBuilder)this.renderedBlock.getRenderElement()).markDirty();
        });
        this.addRenderableWidget(this.areaAlign);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.wand.getHoverName(), x + (this.background.getWidth() - this.font.width((FormattedText)this.wand.getHoverName())) / 2, y + 4, -10935260, false);
    }

    private void transformBlock(PoseStack ms, float p) {
        ms.translate(0.1875f, 0.9375f, 0.0f);
        ms.mulPose((Quaternionfc)Axis.of((Vector3f)new Vector3f(0.3f, 1.0f, 0.0f)).rotationDegrees(-22.5f));
        ms.scale(1.0f, -1.0f, 1.0f);
        SymmetryHandlerClient.applyModelTransform(this.currentElement, ms);
    }

    public void removed() {
        SymmetryWandItem.configureSettings(this.wand, this.currentElement);
        this.minecraft.player.connection.send((Packet)new ConfigureSymmetryWandPacket(this.hand, this.currentElement));
    }
}

