/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlock;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;

public class ToolBoxVisual
extends AbstractBlockEntityVisual<ToolboxBlockEntity>
implements SimpleDynamicVisual {
    private final Direction facing;
    private final TransformedInstance lid;
    private final TransformedInstance[] drawers;
    private float lastLidAngle = Float.NaN;
    private float lastDrawerOffset = Float.NaN;

    public ToolBoxVisual(VisualizationContext context, ToolboxBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.facing = ((Direction)this.blockState.getValue((Property)ToolboxBlock.FACING)).getOpposite();
        Instancer<TransformedInstance> drawerModel = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.TOOLBOX_DRAWER));
        this.drawers = new TransformedInstance[]{drawerModel.createInstance(), drawerModel.createInstance()};
        this.lid = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.TOOLBOX_LIDS.get(blockEntity.getColor()))).createInstance();
        this.animate(partialTick);
    }

    @Override
    protected void _delete() {
        this.lid.delete();
        for (TransformedInstance drawer : this.drawers) {
            drawer.delete();
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        float lidAngle = ((ToolboxBlockEntity)this.blockEntity).lid.getValue(partialTicks);
        float drawerOffset = ((ToolboxBlockEntity)this.blockEntity).drawers.getValue(partialTicks);
        if (lidAngle != this.lastLidAngle) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.lid.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(-this.facing.toYRot())).uncenter()).translate(0.0f, 0.375f, 0.75f).rotateXDegrees(135.0f * lidAngle)).translateBack(0.0f, 0.375f, 0.75f)).setChanged();
        }
        if (drawerOffset != this.lastDrawerOffset) {
            for (int offset : Iterate.zeroAndOne) {
                ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.drawers[offset].setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees(-this.facing.toYRot())).uncenter()).translate(0.0f, (float)(offset * 1) / 8.0f, -drawerOffset * 0.175f * (float)(2 - offset)).setChanged();
            }
        }
        this.lastLidAngle = lidAngle;
        this.lastDrawerOffset = drawerOffset;
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.drawers);
        this.relight(this.lid);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.lid);
        for (TransformedInstance drawer : this.drawers) {
            consumer.accept(drawer);
        }
    }
}

