/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.toolbox;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.Create;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.zurrtum.create.content.equipment.toolbox.ToolboxMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.ToolboxDisposeAllPacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;

public class ToolboxScreen
extends AbstractSimiContainerScreen<ToolboxMenu> {
    protected static final AllGuiTextures BG = AllGuiTextures.TOOLBOX;
    protected static final AllGuiTextures PLAYER = AllGuiTextures.PLAYER_INVENTORY;
    protected Slot hoveredToolboxSlot;
    private IconButton confirmButton;
    private IconButton disposeButton;
    private ElementWidget renderedItem;
    private ElementWidget renderedLid;
    private ElementWidget renderedTopDrawer;
    private ElementWidget renderedBottomDrawer;
    private ElementWidget renderedTopLeftDrawer;
    private ElementWidget renderedTopBottomDrawer;
    private DyeColor color;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public ToolboxScreen(ToolboxMenu menu, Inventory inv, Component title) {
        super(menu, inv, title);
        this.init();
    }

    public static ToolboxScreen create(Minecraft mc, MenuType<ToolboxBlockEntity> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        ToolboxBlockEntity entity = (ToolboxBlockEntity)ToolboxScreen.getBlockEntity(mc, extraData);
        if (entity == null) {
            return null;
        }
        try (ProblemReporter.ScopedCollector logging = new ProblemReporter.ScopedCollector(entity.problemPath(), Create.LOGGER);){
            ValueInput view = TagValueInput.create((ProblemReporter)logging, (HolderLookup.Provider)extraData.registryAccess(), (CompoundTag)extraData.readNbt());
            entity.readClient(view);
            ToolboxScreen toolboxScreen = (ToolboxScreen)((Object)type.create(ToolboxScreen::new, syncId, inventory, title, entity));
            return toolboxScreen;
        }
    }

    @Override
    protected void init() {
        this.setWindowSize(30 + BG.getWidth(), BG.getHeight() + PLAYER.getHeight() - 24);
        this.setWindowOffset(-11, 0);
        super.init();
        this.clearWidgets();
        this.color = ((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).getColor();
        this.confirmButton = new IconButton(this.leftPos + 30 + BG.getWidth() - 33, this.topPos + BG.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.disposeButton = new IconButton(this.leftPos + 30 + 81, this.topPos + 69, AllIcons.I_TOOLBOX);
        this.disposeButton.withCallback(() -> this.minecraft.player.connection.send((Packet)new ToolboxDisposeAllPacket(((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).getBlockPos())));
        this.disposeButton.setToolTip((Component)CreateLang.translateDirect("toolbox.depositBox", new Object[0]));
        this.addRenderableWidget(this.disposeButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + 30 + BG.getWidth(), this.topPos + BG.getHeight() - 15 - 34 - 6, 72, 68));
        int x1 = this.leftPos + this.imageWidth - 1;
        int y1 = this.topPos + BG.getHeight() - 13;
        this.renderedTopDrawer = new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125f).transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f));
        this.addRenderableWidget(this.renderedTopDrawer);
        this.renderedItem = new ElementWidget(this.leftPos + this.imageWidth + 5, this.topPos + BG.getHeight() - 54).showingElement(GuiGameElement.of(((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).getBlockState().getBlock().defaultBlockState()).scale(3.125f).rotate(-22.0f, -202.0f, 0.0f).padding(12));
        this.addRenderableWidget(this.renderedItem);
        this.renderedLid = new ElementWidget(this.leftPos + this.imageWidth + 10, this.topPos + BG.getHeight() - 58).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_LIDS.get(this.color)).scale(3.125f).transform(this::transformLid).padding(6));
        this.addRenderableWidget(this.renderedLid);
        this.renderedBottomDrawer = new ElementWidget(x1, this.topPos + BG.getHeight() - 7).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125f).transform(this::transformBottomDrawer).atLocal(-0.2f, 0.4f));
        this.addRenderableWidget(this.renderedBottomDrawer);
        this.renderedTopLeftDrawer = ((ElementWidget)new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125f).transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f))).withScissor(0, 0, 15, 50);
        this.addRenderableWidget(this.renderedTopLeftDrawer);
        this.renderedTopBottomDrawer = ((ElementWidget)new ElementWidget(x1, y1).showingElement(GuiGameElement.of(AllPartialModels.TOOLBOX_DRAWER).scale(3.125f).transform(this::transformTopDrawer).atLocal(-0.2f, 0.4f))).withScissor(0, 6, 50, 44);
        this.addRenderableWidget(this.renderedTopBottomDrawer);
    }

    private void transformLid(PoseStack ms, float partialTicks) {
        ms.translate(0.796f, 1.408f, 0.0f);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateXDegrees(-22.0f)).rotateYDegrees(-202.0f)).translate(0.0f, -0.375f, 0.75f).rotateXDegrees(-105.0f * ((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).lid.getValue(partialTicks))).translate(0.0f, 0.375f, -0.75f);
        ms.scale(1.0f, -1.0f, 1.0f);
    }

    private void transformTopDrawer(PoseStack ms, float partialTicks) {
        ms.translate(1.02f, 0.384f, 0.0f);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateXDegrees(-22.0f)).rotateYDegrees(-202.0f)).translate(0.0f, 0.0f, ((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).drawers.getValue(partialTicks) * -0.175f);
        ms.scale(1.0f, -1.0f, 1.0f);
    }

    private void transformBottomDrawer(PoseStack ms, float partialTicks) {
        ms.translate(1.02f, 0.38f, 0.0f);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateXDegrees(-22.0f)).rotateYDegrees(-202.0f)).translate(0.0f, 0.0f, ((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).drawers.getValue(partialTicks) * -0.175f * 2.0f);
        ms.scale(1.0f, -1.0f, 1.0f);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
        this.renderedLid.getRenderElement().clear();
        this.renderedTopDrawer.getRenderElement().clear();
        this.renderedBottomDrawer.getRenderElement().clear();
        this.renderedTopLeftDrawer.getRenderElement().clear();
        this.renderedTopBottomDrawer.getRenderElement().clear();
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ((ToolboxMenu)this.menu).renderPass = true;
        super.render(graphics, mouseX, mouseY, partialTicks);
        ((ToolboxMenu)this.menu).renderPass = false;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        partialTicks = AnimationTickHolder.getPartialTicksUI(this.minecraft.getDeltaTracker());
        int x = this.leftPos + this.imageWidth - BG.getWidth();
        BG.render(graphics, x, this.topPos);
        graphics.drawString(this.font, this.title, x + 15, this.topPos + 4, -10935260, false);
        int invX = this.leftPos;
        int invY = this.topPos + this.imageHeight - PLAYER.getHeight();
        this.renderPlayerInventory(graphics, invX, invY);
        ((GuiGameElement.GuiPartialRenderBuilder)this.renderedLid.getRenderElement()).tick(((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).lid.settled() ? 1.0f : partialTicks);
        float drawerTicks = ((ToolboxBlockEntity)((ToolboxMenu)this.menu).contentHolder).drawers.settled() ? 1.0f : partialTicks;
        ((GuiGameElement.GuiPartialRenderBuilder)this.renderedTopDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiGameElement.GuiPartialRenderBuilder)this.renderedBottomDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiGameElement.GuiPartialRenderBuilder)this.renderedTopLeftDrawer.getRenderElement()).tick(drawerTicks);
        ((GuiGameElement.GuiPartialRenderBuilder)this.renderedTopBottomDrawer.getRenderElement()).tick(drawerTicks);
        this.hoveredToolboxSlot = null;
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            Slot slot = (Slot)((ToolboxMenu)this.menu).slots.get(baseIndex);
            ItemStack itemstack = slot.getItem();
            int i = slot.x + this.leftPos;
            int j = slot.y + this.topPos;
            if (itemstack.isEmpty()) {
                itemstack = ((ToolboxMenu)this.menu).getFilter(compartment);
            }
            if (this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
                this.hoveredToolboxSlot = slot;
                int slotColor = -2130706433;
                graphics.fillGradient(i, j, i + 16, j + 16, slotColor, slotColor);
            }
            if (itemstack.isEmpty()) continue;
            int count = ((ToolboxMenu)this.menu).totalCountInCompartment(compartment);
            String s = String.valueOf(count);
            graphics.renderItem((LivingEntity)this.minecraft.player, itemstack, i, j, 0);
            graphics.renderItemDecorations(this.font, itemstack, i, j, s);
        }
    }

    @Override
    protected void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hoveredToolboxSlot != null) {
            this.hoveredSlot = this.hoveredToolboxSlot;
        }
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

