/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.zapper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public abstract class ShootableGadgetRenderHandler {
    protected float leftHandAnimation;
    protected float rightHandAnimation;
    protected float lastLeftHandAnimation;
    protected float lastRightHandAnimation;
    protected boolean dontReequipLeft;
    protected boolean dontReequipRight;

    public void tick() {
        this.lastLeftHandAnimation = this.leftHandAnimation;
        this.lastRightHandAnimation = this.rightHandAnimation;
        this.leftHandAnimation *= this.animationDecay();
        this.rightHandAnimation *= this.animationDecay();
    }

    public float getAnimation(boolean rightHand, float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)(rightHand ? this.lastRightHandAnimation : this.lastLeftHandAnimation), (float)(rightHand ? this.rightHandAnimation : this.leftHandAnimation));
    }

    protected float animationDecay() {
        return 0.8f;
    }

    public void shoot(InteractionHand hand, Vec3 location) {
        LocalPlayer player;
        boolean rightHand = hand == InteractionHand.MAIN_HAND ^ (player = Minecraft.getInstance().player).getMainArm() == HumanoidArm.LEFT;
        if (rightHand) {
            this.rightHandAnimation = 0.2f;
            this.dontReequipRight = false;
        } else {
            this.leftHandAnimation = 0.2f;
            this.dontReequipLeft = false;
        }
        this.playSound(hand, location);
    }

    public abstract void playSound(InteractionHand var1, Vec3 var2);

    protected abstract boolean appliesTo(ItemStack var1);

    protected abstract void transformTool(PoseStack var1, float var2, float var3, float var4, float var5);

    protected abstract void transformHand(PoseStack var1, float var2, float var3, float var4, float var5);

    public boolean onRenderPlayerHand(ItemStack heldItem, Minecraft mc, EntityRenderDispatcher entityRenderDispatcher, ItemInHandRenderer firstPersonRenderer, PoseStack ms, SubmitNodeCollector queue, int light, float pt, InteractionHand hand, float equipProgress, float swingProgress) {
        float recoil;
        if (!this.appliesTo(heldItem)) {
            return false;
        }
        LocalPlayer player = mc.player;
        AvatarRenderer playerrenderer = entityRenderDispatcher.getPlayerRenderer((AbstractClientPlayer)player);
        boolean rightHand = hand == InteractionHand.MAIN_HAND ^ player.getMainArm() == HumanoidArm.LEFT;
        float f = recoil = rightHand ? Mth.lerp((float)pt, (float)this.lastRightHandAnimation, (float)this.rightHandAnimation) : Mth.lerp((float)pt, (float)this.lastLeftHandAnimation, (float)this.leftHandAnimation);
        if (rightHand && (this.rightHandAnimation > 0.01f || this.dontReequipRight)) {
            equipProgress = 0.0f;
        }
        if (!rightHand && (this.leftHandAnimation > 0.01f || this.dontReequipLeft)) {
            equipProgress = 0.0f;
        }
        float flip = rightHand ? 1.0f : -1.0f;
        float f1 = Mth.sqrt((float)swingProgress);
        float f2 = -0.3f * Mth.sin((double)(f1 * (float)Math.PI));
        float f3 = 0.4f * Mth.sin((double)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * Mth.sin((double)(swingProgress * (float)Math.PI));
        float f5 = Mth.sin((double)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = Mth.sin((double)(f1 * (float)Math.PI));
        ms.pushPose();
        ms.translate(flip * (f2 + 0.64f - 0.1f), f3 + -0.4f + equipProgress * -0.6f, f4 + -0.72f + 0.3f + recoil);
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(flip * 75.0f));
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(flip * f6 * 70.0f));
        ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(flip * f5 * -20.0f));
        ms.translate(flip * -1.0f, 3.6f, 3.5f);
        ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(flip * 120.0f));
        ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(200.0f));
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(flip * -135.0f));
        ms.translate(flip * 5.6f, 0.0f, 0.0f);
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(flip * 40.0f));
        this.transformHand(ms, flip, equipProgress, recoil, pt);
        Identifier texture = player.getSkin().body().texturePath();
        if (rightHand) {
            playerrenderer.renderRightHand(ms, queue, light, texture, player.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE));
        } else {
            playerrenderer.renderLeftHand(ms, queue, light, texture, player.isModelPartShown(PlayerModelPart.LEFT_SLEEVE));
        }
        ms.popPose();
        ms.pushPose();
        ms.translate(flip * (f2 + 0.64f - 0.1f), f3 + -0.4f + equipProgress * -0.6f, f4 + -0.72f - 0.1f + recoil);
        ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(flip * f6 * 70.0f));
        ms.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(flip * f5 * -20.0f));
        this.transformTool(ms, flip, equipProgress, recoil, pt);
        firstPersonRenderer.renderItem((LivingEntity)player, heldItem, rightHand ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ms, queue, light);
        ms.popPose();
        return true;
    }

    public void dontAnimateItem(InteractionHand hand) {
        LocalPlayer player = Minecraft.getInstance().player;
        boolean rightHand = hand == InteractionHand.MAIN_HAND ^ player.getMainArm() == HumanoidArm.LEFT;
        this.dontReequipRight |= rightHand;
        this.dontReequipLeft |= !rightHand;
    }
}

