/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.zapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.zapper.ConfigureZapperPacket;
import com.zurrtum.create.infrastructure.component.PlacementPatterns;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ZapperScreen
extends AbstractSimiScreen {
    protected final Component patternSection = CreateLang.translateDirect("gui.terrainzapper.patternSection", new Object[0]);
    protected AllGuiTextures background;
    protected ItemStack zapper;
    protected InteractionHand hand;
    protected float animationProgress;
    protected ElementWidget renderedItem;
    protected ElementWidget renderedBlock;
    protected Component title;
    protected List<IconButton> patternButtons = new ArrayList<IconButton>(6);
    private IconButton confirmButton;
    protected int brightColor;
    protected int fontColor;
    protected PlacementPatterns currentPattern;

    public ZapperScreen(AllGuiTextures background, ItemStack zapper, InteractionHand hand) {
        this.background = background;
        this.zapper = zapper;
        this.hand = hand;
        this.title = CommonComponents.EMPTY;
        this.brightColor = 0xFEFEFE;
        this.fontColor = -11051142;
        this.currentPattern = (PlacementPatterns)((Object)zapper.getOrDefault(AllDataComponents.PLACEMENT_PATTERN, (Object)PlacementPatterns.Solid));
    }

    public AllIcons getIcon(PlacementPatterns pattern) {
        return switch (pattern) {
            default -> throw new MatchException(null, null);
            case PlacementPatterns.Solid -> AllIcons.I_PATTERN_SOLID;
            case PlacementPatterns.Checkered -> AllIcons.I_PATTERN_CHECKERED;
            case PlacementPatterns.InverseCheckered -> AllIcons.I_PATTERN_CHECKERED_INVERSED;
            case PlacementPatterns.Chance25 -> AllIcons.I_PATTERN_CHANCE_25;
            case PlacementPatterns.Chance50 -> AllIcons.I_PATTERN_CHANCE_50;
            case PlacementPatterns.Chance75 -> AllIcons.I_PATTERN_CHANCE_75;
        };
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-10, 0);
        super.init();
        this.animationProgress = 0.0f;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.patternButtons.clear();
        for (int row = 0; row <= 1; ++row) {
            for (int col = 0; col <= 2; ++col) {
                int id = this.patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + this.background.getWidth() - 76 + col * 18, y + 21 + row * 18, this.getIcon(pattern));
                patternButton.withCallback(() -> {
                    this.patternButtons.forEach(b -> {
                        b.green = false;
                    });
                    patternButton.green = true;
                    this.currentPattern = pattern;
                });
                patternButton.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.pattern." + pattern.translationKey, new Object[0]));
                this.patternButtons.add(patternButton);
            }
        }
        this.patternButtons.get((int)this.currentPattern.ordinal()).green = true;
        this.addRenderableWidgets(this.patternButtons);
        this.renderedItem = new ElementWidget(x + this.background.getWidth(), y + this.background.getHeight() - 48).showingElement(GuiGameElement.of(this.zapper).scale(4.0f));
        this.addRenderableWidget(this.renderedItem);
        this.renderedBlock = new ElementWidget(x + 17, y + 24).showingElement(GuiGameElement.of((BlockState)this.zapper.getOrDefault(AllDataComponents.SHAPER_BLOCK_USED, (Object)Blocks.AIR.defaultBlockState())).scale(1.25f).rotate(-25.0f, -45.0f, 0.0f).padding(10));
        this.addRenderableWidget(this.renderedBlock);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
        this.renderedBlock.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        this.drawOnBackground(graphics, x, y);
    }

    protected void drawOnBackground(GuiGraphics graphics, int x, int y) {
        graphics.drawString(this.font, this.title, x + (this.background.getWidth() - this.font.width((FormattedText)this.title)) / 2, y + 4, -11263665, false);
    }

    @Override
    public void tick() {
        super.tick();
        this.animationProgress += 5.0f;
    }

    public void removed() {
        ConfigureZapperPacket packet = this.getConfigurationPacket();
        packet.configureZapper(this.zapper);
        this.minecraft.player.connection.send((Packet)packet);
    }

    protected abstract ConfigureZapperPacket getConfigurationPacket();
}

