/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.content.equipment.zapper.ZapperScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.zapper.ConfigureZapperPacket;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.Brush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.CylinderBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.DynamicBrush;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.SphereBrush;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import com.zurrtum.create.infrastructure.component.TerrainBrushes;
import com.zurrtum.create.infrastructure.component.TerrainTools;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureWorldshaperPacket;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class WorldshaperScreen
extends ZapperScreen {
    protected final Component placementSection = CreateLang.translateDirect("gui.terrainzapper.placement", new Object[0]);
    protected final Component toolSection = CreateLang.translateDirect("gui.terrainzapper.tool", new Object[0]);
    protected final List<Component> brushOptions = CreateLang.translatedOptions("gui.terrainzapper.brush", "cuboid", "sphere", "cylinder", "surface", "cluster");
    protected List<IconButton> toolButtons;
    protected List<IconButton> placementButtons;
    protected ScrollInput brushInput;
    protected Label brushLabel;
    protected List<ScrollInput> brushParams = new ArrayList<ScrollInput>(3);
    protected List<Label> brushParamLabels = new ArrayList<Label>(3);
    protected IconButton followDiagonals;
    protected IconButton acrossMaterials;
    protected Indicator followDiagonalsIndicator;
    protected Indicator acrossMaterialsIndicator;
    protected TerrainBrushes currentBrush;
    protected int[] currentBrushParams = new int[]{1, 1, 1};
    protected boolean currentFollowDiagonals;
    protected boolean currentAcrossMaterials;
    protected TerrainTools currentTool;
    protected PlacementOptions currentPlacement;

    public WorldshaperScreen(ItemStack zapper, InteractionHand hand) {
        super(AllGuiTextures.TERRAINZAPPER, zapper, hand);
        this.fontColor = -9013642;
        this.title = zapper.getHoverName();
        this.currentBrush = (TerrainBrushes)((Object)zapper.getOrDefault(AllDataComponents.SHAPER_BRUSH, (Object)TerrainBrushes.Cuboid));
        if (zapper.has(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            BlockPos paramsData = (BlockPos)zapper.get(AllDataComponents.SHAPER_BRUSH_PARAMS);
            this.currentBrushParams[0] = paramsData.getX();
            this.currentBrushParams[1] = paramsData.getY();
            this.currentBrushParams[2] = paramsData.getZ();
            if (this.currentBrushParams[1] == 0) {
                this.currentFollowDiagonals = true;
            }
            if (this.currentBrushParams[2] == 0) {
                this.currentAcrossMaterials = true;
            }
        }
        this.currentTool = (TerrainTools)((Object)zapper.getOrDefault(AllDataComponents.SHAPER_TOOL, (Object)TerrainTools.Fill));
        this.currentPlacement = (PlacementOptions)((Object)zapper.getOrDefault(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, (Object)PlacementOptions.Merged));
    }

    @Override
    protected void init() {
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.brushLabel = new Label(x + 61, y + 25, CommonComponents.EMPTY).withShadow();
        this.brushInput = new SelectionScrollInput(x + 56, y + 20, 77, 18).forOptions(this.brushOptions).titled(CreateLang.translateDirect("gui.terrainzapper.brush", new Object[0])).writingTo(this.brushLabel).calling(brushIndex -> {
            this.currentBrush = TerrainBrushes.values()[brushIndex];
            this.initBrushParams(x, y);
        });
        this.brushInput.setState(this.currentBrush.ordinal());
        this.addRenderableWidget(this.brushLabel);
        this.addRenderableWidget(this.brushInput);
        this.initBrushParams(x, y);
    }

    public AllIcons getIcon(TerrainTools tool) {
        return switch (tool) {
            default -> throw new MatchException(null, null);
            case TerrainTools.Fill -> AllIcons.I_FILL;
            case TerrainTools.Place -> AllIcons.I_PLACE;
            case TerrainTools.Replace -> AllIcons.I_REPLACE;
            case TerrainTools.Clear -> AllIcons.I_CLEAR;
            case TerrainTools.Overlay -> AllIcons.I_OVERLAY;
            case TerrainTools.Flatten -> AllIcons.I_FLATTEN;
        };
    }

    public AllIcons getIcon(PlacementOptions option) {
        return switch (option) {
            default -> throw new MatchException(null, null);
            case PlacementOptions.Merged -> AllIcons.I_CENTERED;
            case PlacementOptions.Attached -> AllIcons.I_ATTACHED;
            case PlacementOptions.Inserted -> AllIcons.I_INSERTED;
        };
    }

    public static Component getParamLabel(Brush brush, int paramIndex) {
        Brush brush2 = brush;
        Objects.requireNonNull(brush2);
        Brush brush3 = brush2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DynamicBrush.class, SphereBrush.class, CylinderBrush.class}, (Object)brush3, n)) {
            case 0 -> {
                DynamicBrush b = (DynamicBrush)brush3;
                yield CreateLang.translateDirect("generic.range", new Object[0]);
            }
            case 1 -> {
                SphereBrush b = (SphereBrush)brush3;
                yield CreateLang.translateDirect("generic.radius", new Object[0]);
            }
            case 2 -> {
                CylinderBrush b = (CylinderBrush)brush3;
                if (paramIndex == 0) {
                    yield CreateLang.translateDirect("generic.radius", new Object[0]);
                }
                yield CreateLang.translateDirect(paramIndex == 1 ? "generic.height" : "generic.length", new Object[0]);
            }
            default -> CreateLang.translateDirect(paramIndex == 0 ? "generic.width" : (paramIndex == 1 ? "generic.height" : "generic.length"), new Object[0]);
        };
    }

    protected void initBrushParams(int x, int y) {
        Brush currentBrush = this.currentBrush.get();
        this.removeWidgets(this.brushParamLabels);
        this.removeWidgets(this.brushParams);
        this.brushParamLabels.clear();
        this.brushParams.clear();
        for (int index = 0; index < 3; ++index) {
            Label label = new Label(x + 65 + 20 * index, y + 45, CommonComponents.EMPTY).withShadow();
            int finalIndex = index;
            ScrollInput input = new ScrollInput(x + 56 + 20 * index, y + 40, 18, 18).withRange(currentBrush.getMin(index), currentBrush.getMax(index) + 1).writingTo(label).titled(WorldshaperScreen.getParamLabel(currentBrush, index).plainCopy()).calling(state -> {
                this.currentBrushParams[finalIndex] = state;
                label.setX(x + 65 + 20 * finalIndex - this.font.width((FormattedText)label.text) / 2);
            });
            input.setState(this.currentBrushParams[index]);
            input.onChanged();
            if (index >= currentBrush.amtParams) {
                input.visible = false;
                label.visible = false;
                input.active = false;
            }
            this.brushParamLabels.add(label);
            this.brushParams.add(input);
        }
        this.addRenderableWidgets(this.brushParamLabels);
        this.addRenderableWidgets(this.brushParams);
        if (this.followDiagonals != null) {
            this.removeWidget(this.followDiagonals);
            this.removeWidget(this.followDiagonalsIndicator);
            this.removeWidget(this.acrossMaterials);
            this.removeWidget(this.acrossMaterialsIndicator);
            this.followDiagonals = null;
            this.followDiagonalsIndicator = null;
            this.acrossMaterials = null;
            this.acrossMaterialsIndicator = null;
        }
        if (currentBrush.hasConnectivityOptions()) {
            int x1 = x + 7 + 72;
            int y1 = y + 79;
            this.followDiagonalsIndicator = new Indicator(x1, y1 - 6, CommonComponents.EMPTY);
            this.followDiagonals = new IconButton(x1, y1, AllIcons.I_FOLLOW_DIAGONAL);
            this.acrossMaterialsIndicator = new Indicator(x1 += 18, y1 - 6, CommonComponents.EMPTY);
            this.acrossMaterials = new IconButton(x1, y1, AllIcons.I_FOLLOW_MATERIAL);
            this.followDiagonals.withCallback(() -> {
                this.followDiagonalsIndicator.state = this.followDiagonalsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentFollowDiagonals = !this.currentFollowDiagonals;
            });
            this.followDiagonals.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.searchDiagonal", new Object[0]));
            this.acrossMaterials.withCallback(() -> {
                this.acrossMaterialsIndicator.state = this.acrossMaterialsIndicator.state == Indicator.State.OFF ? Indicator.State.ON : Indicator.State.OFF;
                this.currentAcrossMaterials = !this.currentAcrossMaterials;
            });
            this.acrossMaterials.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.searchFuzzy", new Object[0]));
            this.addRenderableWidget(this.followDiagonals);
            this.addRenderableWidget(this.followDiagonalsIndicator);
            this.addRenderableWidget(this.acrossMaterials);
            this.addRenderableWidget(this.acrossMaterialsIndicator);
            if (this.currentFollowDiagonals) {
                this.followDiagonalsIndicator.state = Indicator.State.ON;
            }
            if (this.currentAcrossMaterials) {
                this.acrossMaterialsIndicator.state = Indicator.State.ON;
            }
        }
        if (this.toolButtons != null) {
            this.removeWidgets(this.toolButtons);
        }
        TerrainTools[] toolValues = currentBrush.getSupportedTools();
        this.toolButtons = new ArrayList<IconButton>(toolValues.length);
        for (int id = 0; id < toolValues.length; ++id) {
            TerrainTools tool = toolValues[id];
            IconButton toolButton = new IconButton(x + 7 + id * 18, y + 79, this.getIcon(tool));
            toolButton.withCallback(() -> {
                this.toolButtons.forEach(b -> {
                    b.green = false;
                });
                toolButton.green = true;
                this.currentTool = tool;
            });
            toolButton.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.tool." + tool.translationKey, new Object[0]));
            this.toolButtons.add(toolButton);
        }
        int toolIndex = -1;
        for (int i = 0; i < toolValues.length; ++i) {
            if (this.currentTool != toolValues[i]) continue;
            toolIndex = i;
        }
        if (toolIndex == -1) {
            this.currentTool = toolValues[0];
            toolIndex = 0;
        }
        this.toolButtons.get((int)toolIndex).green = true;
        this.addRenderableWidgets(this.toolButtons);
        if (this.placementButtons != null) {
            this.removeWidgets(this.placementButtons);
        }
        if (currentBrush.hasPlacementOptions()) {
            PlacementOptions[] placementValues = PlacementOptions.values();
            this.placementButtons = new ArrayList<IconButton>(placementValues.length);
            for (int id = 0; id < placementValues.length; ++id) {
                PlacementOptions option = placementValues[id];
                IconButton placementButton = new IconButton(x + 136 + id * 18, y + 79, this.getIcon(option));
                placementButton.withCallback(() -> {
                    this.placementButtons.forEach(b -> {
                        b.green = false;
                    });
                    placementButton.green = true;
                    this.currentPlacement = option;
                });
                placementButton.setToolTip((Component)CreateLang.translateDirect("gui.terrainzapper.placement." + option.translationKey, new Object[0]));
                this.placementButtons.add(placementButton);
            }
            this.placementButtons.get((int)this.currentPlacement.ordinal()).green = true;
            this.addRenderableWidgets(this.placementButtons);
        }
    }

    @Override
    protected void drawOnBackground(GuiGraphics graphics, int x, int y) {
        super.drawOnBackground(graphics, x, y);
        Brush currentBrush = this.currentBrush.get();
        for (int index = 2; index >= currentBrush.amtParams; --index) {
            AllGuiTextures.TERRAINZAPPER_INACTIVE_PARAM.render(graphics, x + 56 + 20 * index, y + 40);
        }
        graphics.drawString(this.font, this.toolSection, x + 7, y + 69, this.fontColor, false);
        if (currentBrush.hasPlacementOptions()) {
            graphics.drawString(this.font, this.placementSection, x + 136, y + 69, this.fontColor, false);
        }
    }

    @Override
    protected ConfigureZapperPacket getConfigurationPacket() {
        int brushParamY;
        int brushParamX = this.currentBrushParams[0];
        int n = this.followDiagonalsIndicator != null ? (this.followDiagonalsIndicator.state == Indicator.State.ON ? 0 : 1) : (brushParamY = this.currentBrushParams[1]);
        int brushParamZ = this.acrossMaterialsIndicator != null ? (this.acrossMaterialsIndicator.state == Indicator.State.ON ? 0 : 1) : this.currentBrushParams[2];
        return new ConfigureWorldshaperPacket(this.hand, this.currentPattern, this.currentBrush, brushParamX, brushParamY, brushParamZ, this.currentTool, this.currentPlacement);
    }
}

