/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.fluids.pipes.valve;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlock;
import com.zurrtum.create.content.fluids.pipes.valve.FluidValveBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class FluidValveVisual
extends ShaftVisual<FluidValveBlockEntity>
implements SimpleDynamicVisual {
    protected TransformedInstance pointer;
    protected boolean settled;
    protected final double xRot;
    protected final double yRot;
    protected final int pointerRotationOffset;

    public FluidValveVisual(VisualizationContext dispatcher, FluidValveBlockEntity blockEntity, float partialTick) {
        super(dispatcher, blockEntity, partialTick);
        Direction facing = (Direction)this.blockState.getValue((Property)FluidValveBlock.FACING);
        this.yRot = AngleHelper.horizontalAngle(facing);
        this.xRot = facing == Direction.UP ? 0.0 : (facing == Direction.DOWN ? 180.0 : 90.0);
        Direction.Axis pipeAxis = FluidValveBlock.getPipeAxis(this.blockState);
        Direction.Axis shaftAxis = KineticBlockEntityRenderer.getRotationAxisOf(blockEntity);
        boolean twist = pipeAxis.isHorizontal() && shaftAxis == Direction.Axis.X || pipeAxis.isVertical();
        this.pointerRotationOffset = twist ? 90 : 0;
        this.settled = false;
        this.pointer = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.FLUID_VALVE_POINTER)).createInstance();
        this.transformPointer(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (((FluidValveBlockEntity)this.blockEntity).pointer.settled() && this.settled) {
            return;
        }
        this.transformPointer(ctx.partialTick());
    }

    private void transformPointer(float partialTick) {
        float value = ((FluidValveBlockEntity)this.blockEntity).pointer.getValue(partialTick);
        float pointerRotation = Mth.lerpInt((float)value, (int)0, (int)-90);
        this.settled = (value == 0.0f || value == 1.0f) && ((FluidValveBlockEntity)this.blockEntity).pointer.settled();
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pointer.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotateYDegrees((float)this.yRot)).rotateXDegrees((float)this.xRot)).rotateYDegrees((float)this.pointerRotationOffset + pointerRotation)).uncenter()).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.pointer);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.pointer.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.pointer);
    }
}

